/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskQueueListener;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class AsteriskQueueImpl
extends AbstractLiveObject
implements AsteriskQueue {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String name;
    private Integer max;
    private String strategy;
    private Integer serviceLevel;
    private Integer calls;
    private Integer holdTime;
    private Integer talkTime;
    private Integer completed;
    private Integer abandoned;
    private Double serviceLevelPerf;
    private Integer weight;
    private final LockableList<AsteriskQueueEntryImpl> entries;
    private final Timer timer;
    private final LockableMap<String, AsteriskQueueMemberImpl> members;
    private final LockableList<AsteriskQueueListener> listeners;
    private final LockableMap<AsteriskQueueEntry, ServiceLevelTimerTask> serviceLevelTimerTasks;

    AsteriskQueueImpl(AsteriskServerImpl server, String name, Integer max, String strategy, Integer serviceLevel, Integer weight, Integer calls, Integer holdTime, Integer talkTime, Integer completed, Integer abandoned, Double serviceLevelPerf) {
        super(server);
        this.name = name;
        this.max = max;
        this.strategy = strategy;
        this.serviceLevel = serviceLevel;
        this.weight = weight;
        this.entries = new LockableList(new ArrayList(25));
        this.listeners = new LockableList(new ArrayList());
        this.members = new LockableMap(new HashMap());
        this.timer = new Timer("ServiceLevelTimer-" + name, true);
        this.serviceLevelTimerTasks = new LockableMap(new HashMap());
        this.calls = calls;
        this.holdTime = holdTime;
        this.talkTime = talkTime;
        this.completed = completed;
        this.abandoned = abandoned;
        this.serviceLevelPerf = serviceLevelPerf;
        this.stampLastUpdate();
    }

    void cancelServiceLevelTimer() {
        this.timer.cancel();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    boolean setMax(Integer max) {
        if (!AstUtil.isEqual(this.max, max)) {
            this.max = max;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getServiceLevel() {
        return this.serviceLevel;
    }

    boolean setServiceLevel(Integer serviceLevel) {
        if (!AstUtil.isEqual(this.serviceLevel, serviceLevel)) {
            this.serviceLevel = serviceLevel;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getCalls() {
        return this.calls;
    }

    boolean setCalls(Integer calls) {
        if (!AstUtil.isEqual(this.calls, calls)) {
            this.calls = calls;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getWaiting() {
        return this.calls;
    }

    @Override
    public Integer getHoldTime() {
        return this.holdTime;
    }

    boolean setHoldTime(Integer holdTime) {
        if (!AstUtil.isEqual(this.holdTime, holdTime)) {
            this.holdTime = holdTime;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getTalkTime() {
        return this.talkTime;
    }

    boolean setTalkTime(Integer talkTime) {
        if (!AstUtil.isEqual(this.talkTime, talkTime)) {
            this.talkTime = talkTime;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getCompleted() {
        return this.completed;
    }

    boolean setCompleted(Integer completed) {
        if (!AstUtil.isEqual(this.completed, completed)) {
            this.completed = completed;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getAbandoned() {
        return this.abandoned;
    }

    boolean setAbandoned(Integer abandoned) {
        if (!AstUtil.isEqual(this.abandoned, abandoned)) {
            this.abandoned = abandoned;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Double getServiceLevelPerf() {
        return this.serviceLevelPerf;
    }

    boolean setServiceLevelPerf(Double serviceLevelPerf) {
        if (!AstUtil.isEqual(this.serviceLevelPerf, serviceLevelPerf)) {
            this.serviceLevelPerf = serviceLevelPerf;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    boolean setWeight(Integer weight) {
        if (!AstUtil.isEqual(this.weight, weight)) {
            this.weight = weight;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public List<AsteriskQueueEntry> getEntries() {
        try (Locker.LockCloser closer = this.entries.withLock();){
            ArrayList<AsteriskQueueEntry> arrayList = new ArrayList<AsteriskQueueEntry>(this.entries);
            return arrayList;
        }
    }

    private void shift() {
        int currentPos = 1;
        try (Locker.LockCloser closer = this.entries.withLock();){
            for (AsteriskQueueEntryImpl qe : this.entries) {
                if (qe.getPosition() != currentPos) {
                    qe.setPosition(currentPos);
                }
                ++currentPos;
            }
        }
    }

    void createNewEntry(AsteriskChannelImpl channel, int reportedPosition, Date dateReceived) {
        AsteriskQueueEntryImpl qe = new AsteriskQueueEntryImpl(this.server, this, channel, reportedPosition, dateReceived);
        try (Locker.LockCloser closer = this.entries.withLock();){
            if (this.getEntry(channel.getName()) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ignored duplicate queue entry during population in queue " + this.name + " for channel " + channel.getName());
                }
                return;
            }
            this.entries.add(qe);
            this.shift();
        }
        long delay = (long)this.serviceLevel.intValue() * 1000L;
        if (delay > 0L) {
            ServiceLevelTimerTask timerTask = new ServiceLevelTimerTask(qe);
            this.timer.schedule((TimerTask)timerTask, delay);
            try (Locker.LockCloser closer = this.serviceLevelTimerTasks.withLock();){
                this.serviceLevelTimerTasks.put(qe, timerTask);
            }
        }
        channel.setQueueEntry(qe);
        this.fireNewEntry(qe);
        this.server.fireNewQueueEntry(qe);
    }

    void removeEntry(AsteriskQueueEntryImpl entry, Date dateReceived) {
        boolean changed;
        try (Locker.LockCloser closer = this.serviceLevelTimerTasks.withLock();){
            if (this.serviceLevelTimerTasks.containsKey(entry)) {
                ServiceLevelTimerTask timerTask = this.serviceLevelTimerTasks.get(entry);
                timerTask.cancel();
                this.serviceLevelTimerTasks.remove(entry);
            }
        }
        try (Locker.LockCloser closer = this.entries.withLock();){
            changed = this.entries.remove(entry);
            if (changed) {
                this.shift();
            }
        }
        if (changed) {
            entry.getChannel().setQueueEntry(null);
            entry.left(dateReceived);
            this.fireEntryLeave(entry);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AsteriskQueue[");
        sb.append("name='").append(this.getName()).append("',");
        sb.append("max='").append(this.getMax()).append("',");
        sb.append("strategy='").append(this.getStrategy()).append("',");
        sb.append("serviceLevel='").append(this.getServiceLevel()).append("',");
        sb.append("weight='").append(this.getWeight()).append("',");
        sb.append("calls='").append(this.getCalls()).append("',");
        sb.append("holdTime='").append(this.getHoldTime()).append("',");
        sb.append("talkTime='").append(this.getTalkTime()).append("',");
        sb.append("completed='").append(this.getCompleted()).append("',");
        sb.append("abandoned='").append(this.getAbandoned()).append("',");
        sb.append("serviceLevelPerf='").append(this.getServiceLevelPerf()).append("',");
        try (Locker.LockCloser closer = this.entries.withLock();){
            sb.append("entries='").append(this.entries.toString()).append("',");
        }
        closer = this.members.withLock();
        var3_3 = null;
        try {
            sb.append("members='").append(this.members.toString()).append("',");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (closer != null) {
                if (var3_3 != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    closer.close();
                }
            }
        }
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addAsteriskQueueListener(AsteriskQueueListener listener) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeAsteriskQueueListener(AsteriskQueueListener listener) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            this.listeners.remove(listener);
        }
    }

    void fireNewEntry(AsteriskQueueEntryImpl entry) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onNewEntry(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewEntry()", e);
                }
            }
        }
    }

    void fireEntryLeave(AsteriskQueueEntryImpl entry) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryLeave(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onEntryLeave()", e);
                }
            }
        }
    }

    void fireMemberAdded(AsteriskQueueMemberImpl member) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberAdded(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberAdded()", e);
                }
            }
        }
    }

    void fireMemberRemoved(AsteriskQueueMemberImpl member) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberRemoved(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberRemoved()", e);
                }
            }
        }
    }

    @Override
    public Collection<AsteriskQueueMember> getMembers() {
        ArrayList<AsteriskQueueMember> listOfMembers = new ArrayList<AsteriskQueueMember>(this.members.size());
        try (Locker.LockCloser closer = this.members.withLock();){
            listOfMembers.addAll(this.members.values());
        }
        return listOfMembers;
    }

    AsteriskQueueMemberImpl getMember(String location) {
        try (Locker.LockCloser closer = this.members.withLock();){
            if (this.members.containsKey(location)) {
                AsteriskQueueMemberImpl asteriskQueueMemberImpl = this.members.get(location);
                return asteriskQueueMemberImpl;
            }
        }
        return null;
    }

    void addMember(AsteriskQueueMemberImpl member) {
        try (Locker.LockCloser closer = this.members.withLock();){
            if (this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Adding new member to the queue " + this.getName() + ": " + member.toString());
            this.members.put(member.getLocation(), member);
        }
        this.fireMemberAdded(member);
    }

    AsteriskQueueMemberImpl getMemberByLocation(String location) {
        AsteriskQueueMemberImpl member;
        try (Locker.LockCloser closer = this.members.withLock();){
            member = this.members.get(location);
        }
        if (member == null) {
            this.logger.error("Requested member at location " + location + " not found!");
        }
        return member;
    }

    void fireMemberStateChanged(AsteriskQueueMemberImpl member) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberStateChange(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberStateChange()", e);
                }
            }
        }
    }

    AsteriskQueueEntryImpl getEntry(String channelName) {
        try (Locker.LockCloser closer = this.entries.withLock();){
            for (AsteriskQueueEntryImpl entry : this.entries) {
                if (!entry.getChannel().getName().equals(channelName)) continue;
                AsteriskQueueEntryImpl asteriskQueueEntryImpl = entry;
                return asteriskQueueEntryImpl;
            }
        }
        return null;
    }

    public void removeMember(AsteriskQueueMemberImpl member) {
        try (Locker.LockCloser closer = this.members.withLock();){
            if (!this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Remove member from the queue " + this.getName() + ": " + member.toString());
            this.members.remove(member.getLocation());
        }
        this.fireMemberRemoved(member);
    }

    void fireServiceLevelExceeded(AsteriskQueueEntry entry) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryServiceLevelExceeded(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in fireServiceLevelExceeded()", e);
                }
            }
        }
    }

    AsteriskQueueEntryImpl getEntry(int position) {
        --position;
        AsteriskQueueEntryImpl foundEntry = null;
        try (Locker.LockCloser closer = this.entries.withLock();){
            try {
                foundEntry = this.entries.get(position);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return foundEntry;
    }

    private class ServiceLevelTimerTask
    extends TimerTask {
        private final AsteriskQueueEntry entry;

        ServiceLevelTimerTask(AsteriskQueueEntry entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            AsteriskQueueImpl.this.fireServiceLevelExceeded(this.entry);
        }
    }
}

