/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.DashboardPersister;
import org.wicketstuff.dashboard.DefaultDashboard;
import org.wicketstuff.dashboard.WidgetComparator;

public class XStreamDashboardPersister
implements DashboardPersister {
    private File file;
    private XStream xstream;

    public XStreamDashboardPersister(File file) {
        this.file = file;
        this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        this.xstream.setMode(1001);
        this.xstream.alias("dashboard", DefaultDashboard.class);
    }

    @Override
    public Dashboard load() {
        if (!this.file.exists() || !this.file.isFile()) {
            return null;
        }
        try {
            return (Dashboard)this.xstream.fromXML((InputStream)new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void save(Dashboard dashboard) {
        Collections.sort(dashboard.getWidgets(), new WidgetComparator());
        try {
            this.xstream.toXML((Object)dashboard, (OutputStream)new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

