/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationRuntimeException;
import org.apache.olingo.odata2.annotation.processor.core.util.ClassHelper;
import org.apache.olingo.odata2.api.annotation.edm.EdmComplexType;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntityType;
import org.apache.olingo.odata2.api.annotation.edm.EdmKey;
import org.apache.olingo.odata2.api.annotation.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.exception.ODataException;

public class AnnotationHelper {
    public static final String DEFAULT_CONTAINER_NAME = "DefaultContainer";

    public boolean keyMatch(Object firstInstance, Object secondInstance) {
        if (firstInstance == null || secondInstance == null) {
            return false;
        }
        if (firstInstance.getClass() != secondInstance.getClass()) {
            return false;
        }
        Map<String, Object> firstKeyFields = this.getValueForAnnotatedFields(firstInstance, EdmKey.class);
        Map<String, Object> secondKeyFields = this.getValueForAnnotatedFields(secondInstance, EdmKey.class);
        if (firstKeyFields.isEmpty() && secondKeyFields.isEmpty()) {
            throw new AnnotationRuntimeException("Both object instances does not have EdmKey fields defined [firstClass=" + firstInstance.getClass().getName() + " secondClass=" + secondInstance.getClass().getName() + "].");
        }
        return this.keyValuesMatch(firstKeyFields, secondKeyFields);
    }

    public boolean keyMatch(Object instance, Map<String, Object> keyName2Value) {
        Map<String, Object> instanceKeyFields = this.getValueForAnnotatedFields(instance, EdmKey.class);
        return this.keyValuesMatch(instanceKeyFields, keyName2Value);
    }

    private boolean keyValuesMatch(Map<String, Object> firstKeyValues, Map<String, Object> secondKeyValues) {
        if (firstKeyValues.size() != secondKeyValues.size()) {
            return false;
        }
        if (firstKeyValues.isEmpty()) {
            throw new AnnotationRuntimeException("No keys given for key value matching.");
        }
        Set<Map.Entry<String, Object>> entries = firstKeyValues.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object secondKey;
            Object firstKey = entry.getValue();
            if (this.isEqual(firstKey, secondKey = secondKeyValues.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(Object firstKey, Object secondKey) {
        if (firstKey == null) {
            return secondKey == null || secondKey.equals(firstKey);
        }
        return firstKey.equals(secondKey);
    }

    public String extractEntityTypeName(EdmNavigationProperty enp, Class<?> fallbackClass) {
        Class entityTypeClass = enp.toType();
        return this.extractEntityTypeName(entityTypeClass == Object.class ? fallbackClass : entityTypeClass);
    }

    public String extractEntityTypeName(EdmNavigationProperty enp, Field field) {
        Class entityTypeClass = enp.toType();
        if (entityTypeClass == Object.class) {
            Class toClass = field.getType();
            return this.extractEntityTypeName(toClass.isArray() || Collection.class.isAssignableFrom(toClass) ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : toClass);
        }
        return this.extractEntityTypeName(entityTypeClass);
    }

    public String extractEntityTypeName(Class<?> annotatedClass) {
        return this.extractTypeName(annotatedClass, EdmEntityType.class);
    }

    public String extractEntitySetName(Class<?> annotatedClass) {
        if (annotatedClass == Object.class) {
            return null;
        }
        EdmEntitySet entitySet = annotatedClass.getAnnotation(EdmEntitySet.class);
        if (entitySet == null) {
            return null;
        }
        String name = entitySet.name();
        if (name.isEmpty()) {
            return this.getCanonicalName(annotatedClass) + "Set";
        }
        return name;
    }

    public FullQualifiedName extractEntityTypeFqn(EdmEntityType type, Class<?> annotatedClass) {
        if (type.namespace().isEmpty()) {
            return new FullQualifiedName(this.generateNamespace(annotatedClass), this.extractEntityTypeName(annotatedClass));
        }
        return new FullQualifiedName(type.namespace(), this.extractEntityTypeName(annotatedClass));
    }

    public FullQualifiedName extractEntityTypeFqn(Class<?> annotatedClass) {
        EdmEntityType type = annotatedClass.getAnnotation(EdmEntityType.class);
        if (type == null) {
            return null;
        }
        return this.extractEntityTypeFqn(type, annotatedClass);
    }

    public FullQualifiedName extractComplexTypeFqn(Class<?> annotatedClass) {
        EdmComplexType type = annotatedClass.getAnnotation(EdmComplexType.class);
        if (type == null) {
            return null;
        }
        return this.extractComplexTypeFqn(type, annotatedClass);
    }

    public FullQualifiedName extractComplexTypeFqn(EdmComplexType type, Class<?> annotatedClass) {
        if (type.namespace().isEmpty()) {
            return new FullQualifiedName(this.generateNamespace(annotatedClass), this.extractComplexTypeName(annotatedClass));
        }
        return new FullQualifiedName(type.namespace(), this.extractComplexTypeName(annotatedClass));
    }

    public String extractComplexTypeName(Class<?> annotatedClass) {
        return this.extractTypeName(annotatedClass, EdmComplexType.class);
    }

    public String generateNamespace(Class<?> annotatedClass) {
        return annotatedClass.getPackage().getName();
    }

    private <T extends Annotation> String extractTypeName(Class<?> annotatedClass, Class<T> typeAnnotation) {
        String name;
        if (annotatedClass == Object.class) {
            return null;
        }
        T type = annotatedClass.getAnnotation(typeAnnotation);
        if (type == null) {
            return null;
        }
        if (typeAnnotation == EdmEntityType.class) {
            name = ((EdmEntityType)type).name();
        } else if (typeAnnotation == EdmComplexType.class) {
            name = ((EdmComplexType)type).name();
        } else {
            return null;
        }
        if (name.isEmpty()) {
            return this.getCanonicalName(annotatedClass);
        }
        return name;
    }

    public String getPropertyNameFromAnnotation(Field field) {
        EdmProperty property = field.getAnnotation(EdmProperty.class);
        if (property == null) {
            EdmNavigationProperty navProperty = field.getAnnotation(EdmNavigationProperty.class);
            if (navProperty == null) {
                throw new EdmAnnotationException("Given field '" + field + "' has no EdmProperty or EdmNavigationProperty annotation.");
            }
            return navProperty.name();
        }
        return property.name();
    }

    public String getPropertyName(Field field) {
        String propertyName = this.getPropertyNameFromAnnotation(field);
        if (propertyName.isEmpty()) {
            propertyName = this.getCanonicalName(field);
        }
        return propertyName;
    }

    public String extractToRoleName(EdmNavigationProperty enp, Field field) {
        String role = enp.toRole();
        if (role.isEmpty()) {
            role = this.getCanonicalRoleName(field.getName());
        }
        return role;
    }

    public String extractFromRoleEntityName(Field field) {
        return this.extractEntityTypeName(field.getDeclaringClass());
    }

    public String extractToRoleEntityName(EdmNavigationProperty enp, Field field) {
        Class clazz = enp.toType();
        if (clazz == Object.class) {
            clazz = field.getType().isArray() || Collection.class.isAssignableFrom(field.getType()) ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : field.getType();
        }
        return this.extractEntityTypeName(clazz);
    }

    public String getCanonicalRoleName(String name) {
        return "r_" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public String extractRelationshipName(EdmNavigationProperty enp, Field field) {
        String relationshipName = enp.association();
        if (relationshipName.isEmpty()) {
            String fromRole = this.extractFromRoleEntityName(field);
            String toRole = this.extractToRoleEntityName(enp, field);
            return this.createCanonicalRelationshipName(fromRole, toRole);
        }
        return relationshipName;
    }

    public String createCanonicalRelationshipName(String fromRole, String toRole) {
        if (fromRole.compareTo(toRole) > 0) {
            return toRole + "_2_" + fromRole;
        }
        return fromRole + "_2_" + toRole;
    }

    public EdmMultiplicity extractMultiplicity(EdmNavigationProperty enp, Field field) {
        boolean isCollectionType;
        EdmMultiplicity multiplicity = this.mapMultiplicity(enp.toMultiplicity());
        boolean bl = isCollectionType = field.getType().isArray() || Collection.class.isAssignableFrom(field.getType());
        if (multiplicity == EdmMultiplicity.ONE && isCollectionType) {
            return EdmMultiplicity.MANY;
        }
        return multiplicity;
    }

    public <T> T setKeyFields(T instance, Map<String, Object> keys) {
        List<Field> fields = this.getAnnotatedFields(instance, EdmKey.class);
        for (Field field : fields) {
            String propertyName = this.getPropertyName(field);
            Object keyValue = keys.get(propertyName);
            this.setValueForProperty(instance, propertyName, keyValue);
        }
        return instance;
    }

    public AnnotatedNavInfo getCommonNavigationInfo(Class<?> sourceClass, Class<?> targetClass) {
        List<Field> sourceFields = this.getAnnotatedFields(sourceClass, EdmNavigationProperty.class);
        List<Field> targetFields = this.getAnnotatedFields(targetClass, EdmNavigationProperty.class);
        if (sourceClass == targetClass) {
            return this.getCommonNavigationInfoBiDirectional(sourceClass, targetClass);
        }
        for (Field sourceField : sourceFields) {
            if (ClassHelper.getFieldType(sourceField) != targetClass) continue;
            EdmNavigationProperty sourceNav = sourceField.getAnnotation(EdmNavigationProperty.class);
            String sourceAssociation = this.extractRelationshipName(sourceNav, sourceField);
            for (Field targetField : targetFields) {
                EdmNavigationProperty targetNav;
                String targetAssociation;
                if (ClassHelper.getFieldType(targetField) != sourceClass || !sourceAssociation.equals(targetAssociation = this.extractRelationshipName(targetNav = targetField.getAnnotation(EdmNavigationProperty.class), targetField))) continue;
                return new AnnotatedNavInfo(sourceField, targetField, sourceNav, targetNav);
            }
        }
        return this.getCommonNavigationInfoBiDirectional(sourceClass, targetClass);
    }

    private AnnotatedNavInfo getCommonNavigationInfoBiDirectional(Class<?> sourceClass, Class<?> targetClass) {
        List<Field> sourceFields = this.getAnnotatedFields(sourceClass, EdmNavigationProperty.class);
        String targetEntityTypeName = this.extractEntityTypeName(targetClass);
        for (Field sourceField : sourceFields) {
            EdmNavigationProperty sourceNav = sourceField.getAnnotation(EdmNavigationProperty.class);
            String navTargetEntityName = this.extractEntityTypeName(sourceNav, sourceField);
            if (!navTargetEntityName.equals(targetEntityTypeName)) continue;
            return new AnnotatedNavInfo(null, sourceField, null, sourceNav);
        }
        return null;
    }

    public Class<?> getFieldTypeForProperty(Class<?> clazz, String propertyName) throws ODataAnnotationException {
        if (clazz == null) {
            return null;
        }
        Field field = this.getFieldForPropertyName(propertyName, clazz, true);
        if (field == null) {
            throw new ODataAnnotationException("No field for property '" + propertyName + "' found at class '" + clazz + "'.");
        }
        return field.getType();
    }

    public Class<?> getFieldTypeForProperty(Object instance, String propertyName) throws ODataAnnotationException {
        if (instance == null) {
            return null;
        }
        return this.getFieldTypeForProperty(instance.getClass(), propertyName);
    }

    public Object getValueForProperty(Object instance, String propertyName) throws ODataAnnotationException {
        if (instance == null) {
            return null;
        }
        Field field = this.getFieldForPropertyName(propertyName, instance.getClass(), true);
        if (field == null) {
            throw new ODataAnnotationException("No field for property '" + propertyName + "' found at class '" + instance.getClass() + "'.");
        }
        return this.getFieldValue(instance, field);
    }

    public void setValueForProperty(Object instance, String propertyName, Object propertyValue) {
        Field field;
        if (instance != null && (field = this.getFieldForPropertyName(propertyName, instance.getClass(), true)) != null) {
            this.setFieldValue(instance, field, propertyValue);
        }
    }

    private Field getFieldForPropertyName(String propertyName, Class<?> resultClass, boolean inherited) {
        Field[] fields;
        for (Field field : fields = resultClass.getDeclaredFields()) {
            EdmProperty property = field.getAnnotation(EdmProperty.class);
            if (property == null) continue;
            if (property.name().isEmpty() && this.getCanonicalName(field).equals(propertyName)) {
                return field;
            }
            if (!property.name().equals(propertyName)) continue;
            return field;
        }
        Class<?> superClass = resultClass.getSuperclass();
        if (inherited && superClass != Object.class) {
            return this.getFieldForPropertyName(propertyName, superClass, true);
        }
        return null;
    }

    public Object getValueForField(Object instance, String fieldName, Class<? extends Annotation> annotation) {
        if (instance == null) {
            return null;
        }
        return this.getValueForField(instance, fieldName, instance.getClass(), annotation, true);
    }

    public Object getValueForField(Object instance, Class<? extends Annotation> annotation) {
        if (instance == null) {
            return null;
        }
        return this.getValueForField(instance, instance.getClass(), annotation, true);
    }

    private Object getValueForField(Object instance, Class<?> resultClass, Class<? extends Annotation> annotation, boolean inherited) {
        return this.getValueForField(instance, null, resultClass, annotation, inherited);
    }

    public Map<String, Object> getValueForAnnotatedFields(Object instance, Class<? extends Annotation> annotation) {
        return this.getValueForAnnotatedFields(instance, instance.getClass(), annotation, true);
    }

    private Map<String, Object> getValueForAnnotatedFields(Object instance, Class<?> resultClass, Class<? extends Annotation> annotation, boolean inherited) {
        if (instance == null) {
            return null;
        }
        Field[] fields = resultClass.getDeclaredFields();
        HashMap<String, Object> fieldName2Value = new HashMap<String, Object>();
        for (Field field : fields) {
            if (field.getAnnotation(annotation) == null) continue;
            Object value = this.getFieldValue(instance, field);
            String name = this.extractPropertyName(field);
            fieldName2Value.put(name, value);
        }
        Class<?> superClass = resultClass.getSuperclass();
        if (inherited && superClass != Object.class) {
            Map<String, Object> tmp = this.getValueForAnnotatedFields(instance, superClass, annotation, true);
            fieldName2Value.putAll(tmp);
        }
        return fieldName2Value;
    }

    private String extractPropertyName(Field field) {
        EdmProperty property = field.getAnnotation(EdmProperty.class);
        if (property == null || property.name().isEmpty()) {
            return this.getCanonicalName(field);
        }
        return property.name();
    }

    public void setValueForAnnotatedField(Object instance, Class<? extends Annotation> annotation, Object value) throws ODataAnnotationException {
        List<Field> fields = this.getAnnotatedFields(instance, annotation);
        if (fields.isEmpty()) {
            throw new ODataAnnotationException("No field found for annotation '" + annotation + "' on instance '" + instance + "'.");
        }
        if (fields.size() > 1) {
            throw new ODataAnnotationException("More then one field found for annotation '" + annotation + "' on instance '" + instance + "'.");
        }
        this.setFieldValue(instance, fields.get(0), value);
    }

    public void setValuesToAnnotatedFields(Object instance, Class<? extends Annotation> annotation, Map<String, Object> fieldName2Value) {
        List<Field> fields = this.getAnnotatedFields(instance, annotation);
        for (Field field : fields) {
            String canonicalName = this.getCanonicalName(field);
            if (!fieldName2Value.containsKey(canonicalName)) continue;
            Object value = fieldName2Value.get(canonicalName);
            this.setFieldValue(instance, field, value);
        }
    }

    public List<Field> getAnnotatedFields(Object instance, Class<? extends Annotation> annotation) {
        if (instance == null) {
            return null;
        }
        return this.getAnnotatedFields(instance.getClass(), annotation, true);
    }

    public List<Field> getAnnotatedFields(Class<?> fieldClass, Class<? extends Annotation> annotation) {
        return this.getAnnotatedFields(fieldClass, annotation, true);
    }

    private List<Field> getAnnotatedFields(Class<?> resultClass, Class<? extends Annotation> annotation, boolean inherited) {
        if (resultClass == null) {
            return null;
        }
        Field[] fields = resultClass.getDeclaredFields();
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        Class<?> superClass = resultClass.getSuperclass();
        if (inherited && superClass != Object.class) {
            List<Field> tmp = this.getAnnotatedFields(superClass, annotation, true);
            annotatedFields.addAll(tmp);
        }
        return annotatedFields;
    }

    private Object getValueForField(Object instance, String fieldName, Class<?> resultClass, Class<? extends Annotation> annotation, boolean inherited) {
        Field[] fields;
        if (instance == null) {
            return null;
        }
        for (Field field : fields = resultClass.getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null || fieldName != null && !field.getName().equals(fieldName)) continue;
            return this.getFieldValue(instance, field);
        }
        Class<?> superClass = resultClass.getSuperclass();
        if (inherited && superClass != Object.class) {
            return this.getValueForField(instance, fieldName, superClass, annotation, true);
        }
        return null;
    }

    private Object getFieldValue(Object instance, Field field) {
        try {
            boolean access = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(instance);
            field.setAccessible(access);
            return value;
        }
        catch (IllegalArgumentException ex) {
            throw new AnnotationRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new AnnotationRuntimeException(ex);
        }
    }

    private void setFieldValue(Object instance, Field field, Object value) {
        try {
            Object usedValue = value;
            if (value != null && field.getType() != value.getClass() && value.getClass() == String.class) {
                usedValue = this.convert(field, (String)value);
            }
            boolean access = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, usedValue);
            field.setAccessible(access);
        }
        catch (IllegalArgumentException ex) {
            throw new AnnotationRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new AnnotationRuntimeException(ex);
        }
    }

    private Object convert(Field field, String propertyValue) {
        Class<?> fieldClass = field.getType();
        try {
            EdmProperty property = field.getAnnotation(EdmProperty.class);
            EdmSimpleTypeKind type = this.mapTypeKind(property.type());
            return type.getEdmSimpleTypeInstance().valueOfString(propertyValue, EdmLiteralKind.DEFAULT, null, fieldClass);
        }
        catch (EdmSimpleTypeException ex) {
            throw new AnnotationRuntimeException("Conversion failed for string property [" + propertyValue + "] on field [" + field + "] with error: " + ex.getMessage(), ex);
        }
    }

    public boolean isEdmAnnotated(Object object) {
        if (object == null) {
            return false;
        }
        return this.isEdmAnnotated(object.getClass());
    }

    public boolean isEdmTypeAnnotated(Class<?> clazz) {
        boolean isComplexEntity = clazz.getAnnotation(EdmComplexType.class) != null;
        boolean isEntity = clazz.getAnnotation(EdmEntityType.class) != null;
        return isComplexEntity || isEntity;
    }

    public boolean isEdmAnnotated(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        boolean isEntity = null != clazz.getAnnotation(EdmEntityType.class);
        boolean isEntitySet = null != clazz.getAnnotation(EdmEntitySet.class);
        boolean isComplexEntity = null != clazz.getAnnotation(EdmComplexType.class);
        return isEntity || isComplexEntity || isEntitySet;
    }

    public String getCanonicalName(Field field) {
        return this.firstCharToUpperCase(field.getName());
    }

    public String getCanonicalName(Class<?> clazz) {
        return this.firstCharToUpperCase(clazz.getSimpleName());
    }

    private String firstCharToUpperCase(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return content.substring(0, 1).toUpperCase(Locale.ENGLISH) + content.substring(1);
    }

    public EdmSimpleTypeKind mapTypeKind(EdmType type) {
        switch (type) {
            case BINARY: {
                return EdmSimpleTypeKind.Binary;
            }
            case BOOLEAN: {
                return EdmSimpleTypeKind.Boolean;
            }
            case BYTE: {
                return EdmSimpleTypeKind.Byte;
            }
            case COMPLEX: {
                return EdmSimpleTypeKind.Null;
            }
            case DATE_TIME: {
                return EdmSimpleTypeKind.DateTime;
            }
            case DATE_TIME_OFFSET: {
                return EdmSimpleTypeKind.DateTimeOffset;
            }
            case DECIMAL: {
                return EdmSimpleTypeKind.Decimal;
            }
            case DOUBLE: {
                return EdmSimpleTypeKind.Double;
            }
            case GUID: {
                return EdmSimpleTypeKind.Guid;
            }
            case INT16: {
                return EdmSimpleTypeKind.Int16;
            }
            case INT32: {
                return EdmSimpleTypeKind.Int32;
            }
            case INT64: {
                return EdmSimpleTypeKind.Int64;
            }
            case NULL: {
                return EdmSimpleTypeKind.Null;
            }
            case SBYTE: {
                return EdmSimpleTypeKind.SByte;
            }
            case SINGLE: {
                return EdmSimpleTypeKind.Single;
            }
            case STRING: {
                return EdmSimpleTypeKind.String;
            }
            case TIME: {
                return EdmSimpleTypeKind.Time;
            }
        }
        throw new AnnotationRuntimeException("Unknown type '" + type + "' for mapping to EdmSimpleTypeKind.");
    }

    public EdmMultiplicity mapMultiplicity(EdmNavigationProperty.Multiplicity multiplicity) {
        switch (multiplicity) {
            case ZERO_OR_ONE: {
                return EdmMultiplicity.ZERO_TO_ONE;
            }
            case ONE: {
                return EdmMultiplicity.ONE;
            }
            case MANY: {
                return EdmMultiplicity.MANY;
            }
        }
        throw new AnnotationRuntimeException("Unknown type '" + multiplicity + "' for mapping to EdmMultiplicity.");
    }

    public String getCanonicalNamespace(Class<?> aClass) {
        return this.generateNamespace(aClass);
    }

    public String extractContainerName(Class<?> aClass) {
        String containerName;
        EdmEntitySet entitySet = aClass.getAnnotation(EdmEntitySet.class);
        if (entitySet != null && !(containerName = entitySet.container()).isEmpty()) {
            return containerName;
        }
        return DEFAULT_CONTAINER_NAME;
    }

    private static class EdmAnnotationException
    extends RuntimeException {
        private static final long serialVersionUID = 42L;

        public EdmAnnotationException(String message) {
            super(message);
        }
    }

    public class AnnotatedNavInfo {
        private final Field fromField;
        private final Field toField;
        private final EdmNavigationProperty fromNavigation;
        private final EdmNavigationProperty toNavigation;

        public AnnotatedNavInfo(Field fromField, Field toField, EdmNavigationProperty fromNavigation, EdmNavigationProperty toNavigation) {
            this.fromField = fromField;
            this.toField = toField;
            this.fromNavigation = fromNavigation;
            this.toNavigation = toNavigation;
        }

        public Field getFromField() {
            return this.fromField;
        }

        public String getFromRoleName() {
            if (this.isBiDirectional()) {
                return AnnotationHelper.this.extractFromRoleEntityName(this.toField);
            }
            return AnnotationHelper.this.extractToRoleName(this.toNavigation, this.toField);
        }

        public Field getToField() {
            return this.toField;
        }

        public String getToRoleName() {
            if (this.isBiDirectional()) {
                return AnnotationHelper.this.extractToRoleName(this.toNavigation, this.toField);
            }
            return AnnotationHelper.this.extractToRoleName(this.fromNavigation, this.fromField);
        }

        public EdmMultiplicity getFromMultiplicity() {
            if (this.isBiDirectional()) {
                return EdmMultiplicity.ONE;
            }
            return AnnotationHelper.this.extractMultiplicity(this.toNavigation, this.toField);
        }

        public EdmMultiplicity getToMultiplicity() {
            if (this.isBiDirectional()) {
                return AnnotationHelper.this.extractMultiplicity(this.toNavigation, this.toField);
            }
            return AnnotationHelper.this.extractMultiplicity(this.fromNavigation, this.fromField);
        }

        public boolean isBiDirectional() {
            return this.fromNavigation == null;
        }

        public String getRelationshipName() {
            String toAssociation = this.toNavigation.association();
            String fromAssociation = "";
            if (!this.isBiDirectional()) {
                fromAssociation = this.fromNavigation.association();
            }
            if (fromAssociation.isEmpty() && fromAssociation.equals(toAssociation)) {
                return AnnotationHelper.this.createCanonicalRelationshipName(this.getFromRoleName(), this.getToRoleName());
            }
            if (toAssociation.isEmpty()) {
                return fromAssociation;
            }
            if (!toAssociation.equals(fromAssociation)) {
                throw new AnnotationRuntimeException("Invalid associations for navigation properties '" + this.toString() + "'");
            }
            return toAssociation;
        }

        public String getFromTypeName() {
            if (this.isBiDirectional()) {
                return AnnotationHelper.this.extractEntityTypeName(this.toField.getDeclaringClass());
            }
            return AnnotationHelper.this.extractEntityTypeName(this.fromField.getDeclaringClass());
        }

        public String getToTypeName() {
            if (this.isBiDirectional()) {
                return AnnotationHelper.this.extractEntityTypeName(ClassHelper.getFieldType(this.toField));
            }
            return AnnotationHelper.this.extractEntityTypeName(this.toField.getDeclaringClass());
        }

        public String toString() {
            if (this.isBiDirectional()) {
                return "AnnotatedNavInfo{biDirectional = true, toField=" + this.toField.getName() + ", toNavigation=" + this.toNavigation.name() + '}';
            }
            return "AnnotatedNavInfo{fromField=" + this.fromField.getName() + ", toField=" + this.toField.getName() + ", fromNavigation=" + this.fromNavigation.name() + ", toNavigation=" + this.toNavigation.name() + '}';
        }
    }

    public static final class ODataAnnotationException
    extends ODataException {
        private static final long serialVersionUID = 42L;

        public ODataAnnotationException(String message) {
            super(message);
        }

        public ODataAnnotationException(String message, Exception cause) {
            super(message, (Throwable)cause);
        }
    }
}

