/****************************************************************************
 * crypto/testmngr.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __CRYPTO_TESTMNGR_H
#define __CRYPTO_TESTMNGR_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Public Types
 ****************************************************************************/

struct cipher_testvec
{
  FAR char *key;
  FAR char *iv;
  FAR char *input;
  FAR char *result;
  int np;
  unsigned char fail;
  unsigned char wk;
  unsigned char klen;
  unsigned short ilen;
  unsigned short rlen;
};

/****************************************************************************
 * Public Data
 ****************************************************************************/

#if defined(CONFIG_CRYPTO_AES)

/* AES test vectors */

static struct cipher_testvec aes_enc_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From FIPS-197 */
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .klen = 16,
    .input  = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .ilen = 16,
    .result = "\x69\xc4\xe0\xd8\x6a\x7b\x04\x30"
        "\xd8\xcd\xb7\x80\x70\xb4\xc5\x5a",
    .rlen = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  {
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17",
    .klen = 24,
    .input  = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .ilen = 16,
    .result = "\xdd\xa9\x7c\xa4\x86\x4c\xdf\xe0"
        "\x6e\xaf\x70\xa0\xec\x0d\x71\x91",
    .rlen = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17"
        "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .klen = 32,
    .input  = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .ilen = 16,
    .result = "\x8e\xa2\xb7\xca\x51\x67\x45\xbf"
        "\xea\xfc\x49\x90\x4b\x49\x60\x89",
    .rlen = 16,
  },
#endif
};

static struct cipher_testvec aes_dec_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From FIPS-197 */
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .klen = 16,
    .input  = "\x69\xc4\xe0\xd8\x6a\x7b\x04\x30"
        "\xd8\xcd\xb7\x80\x70\xb4\xc5\x5a",
    .ilen = 16,
    .result = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .rlen = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  {
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17",
    .klen = 24,
    .input  = "\xdd\xa9\x7c\xa4\x86\x4c\xdf\xe0"
        "\x6e\xaf\x70\xa0\xec\x0d\x71\x91",
    .ilen = 16,
    .result = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .rlen = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17"
        "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .klen = 32,
    .input  = "\x8e\xa2\xb7\xca\x51\x67\x45\xbf"
        "\xea\xfc\x49\x90\x4b\x49\x60\x89",
    .ilen = 16,
    .result = "\x00\x11\x22\x33\x44\x55\x66\x77"
        "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .rlen = 16,
  },
#endif
};

static struct cipher_testvec aes_cbc_enc_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From RFC 3602 */
    .key    = "\x06\xa9\x21\x40\x36\xb8\xa1\x5b"
        "\x51\x2e\x03\xd5\x34\x12\x00\x06",
    .klen   = 16,
    .iv = "\x3d\xaf\xba\x42\x9d\x9e\xb4\x30"
        "\xb4\x22\xda\x80\x2c\x9f\xac\x41",
    .input  = "Single block msg",
    .ilen   = 16,
    .result = "\xe3\x53\x77\x9c\x10\x79\xae\xb8"
        "\x27\x08\x94\x2d\xbe\x77\x18\x1a",
    .rlen   = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  {
    .key    = "\xc2\x86\x69\x6d\x88\x7c\x9a\xa0"
        "\x61\x1b\xbb\x3e\x20\x25\xa4\x5a",
    .klen   = 16,
    .iv     = "\x56\x2e\x17\x99\x6d\x09\x3d\x28"
        "\xdd\xb3\xba\x69\x5a\x2e\x6f\x58",
    .input  = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17"
        "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .ilen   = 32,
    .result = "\xd2\x96\xcd\x94\xc2\xcc\xcf\x8a"
        "\x3a\x86\x30\x28\xb5\xe1\xdc\x0a"
        "\x75\x86\x60\x2d\x25\x3c\xff\xf9"
        "\x1b\x82\x66\xbe\xa6\xd6\x1a\xb1",
    .rlen   = 32,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  { /* From NIST SP800-38A */
    .key  = "\x8e\x73\xb0\xf7\xda\x0e\x64\x52"
        "\xc8\x10\xf3\x2b\x80\x90\x79\xe5"
        "\x62\xf8\xea\xd2\x52\x2c\x6b\x7b",
    .klen = 24,
    .iv = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .input  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .ilen = 64,
    .result = "\x4f\x02\x1d\xb2\x43\xbc\x63\x3d"
        "\x71\x78\x18\x3a\x9f\xa0\x71\xe8"
        "\xb4\xd9\xad\xa9\xad\x7d\xed\xf4"
        "\xe5\xe7\x38\x76\x3f\x69\x14\x5a"
        "\x57\x1b\x24\x20\x12\xfb\x7a\xe0"
        "\x7f\xa9\xba\xac\x3d\xf1\x02\xe0"
        "\x08\xb0\xe2\x79\x88\x59\x88\x81"
        "\xd9\x20\xa9\xe6\x4f\x56\x15\xcd",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x60\x3d\xeb\x10\x15\xca\x71\xbe"
        "\x2b\x73\xae\xf0\x85\x7d\x77\x81"
        "\x1f\x35\x2c\x07\x3b\x61\x08\xd7"
        "\x2d\x98\x10\xa3\x09\x14\xdf\xf4",
    .klen = 32,
    .iv = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .input  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .ilen = 64,
    .result = "\xf5\x8c\x4c\x04\xd6\xe5\xf1\xba"
        "\x77\x9e\xab\xfb\x5f\x7b\xfb\xd6"
        "\x9c\xfc\x4e\x96\x7e\xdb\x80\x8d"
        "\x67\x9f\x77\x7b\xc6\x70\x2c\x7d"
        "\x39\xf2\x33\x69\xa9\xd9\xba\xcf"
        "\xa5\x30\xe2\x63\x04\x23\x14\x61"
        "\xb2\xeb\x05\xe2\xc3\x9b\xe9\xfc"
        "\xda\x6c\x19\x07\x8c\x6a\x9d\x1b",
    .rlen = 64,
  },
#endif
};

static struct cipher_testvec aes_cbc_dec_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From RFC 3602 */
    .key    = "\x06\xa9\x21\x40\x36\xb8\xa1\x5b"
        "\x51\x2e\x03\xd5\x34\x12\x00\x06",
    .klen   = 16,
    .iv     = "\x3d\xaf\xba\x42\x9d\x9e\xb4\x30"
        "\xb4\x22\xda\x80\x2c\x9f\xac\x41",
    .input  = "\xe3\x53\x77\x9c\x10\x79\xae\xb8"
        "\x27\x08\x94\x2d\xbe\x77\x18\x1a",
    .ilen   = 16,
    .result = "Single block msg",
    .rlen   = 16,
  },
#endif
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  {
    .key    = "\xc2\x86\x69\x6d\x88\x7c\x9a\xa0"
        "\x61\x1b\xbb\x3e\x20\x25\xa4\x5a",
    .klen   = 16,
    .iv     = "\x56\x2e\x17\x99\x6d\x09\x3d\x28"
        "\xdd\xb3\xba\x69\x5a\x2e\x6f\x58",
    .input  = "\xd2\x96\xcd\x94\xc2\xcc\xcf\x8a"
        "\x3a\x86\x30\x28\xb5\xe1\xdc\x0a"
        "\x75\x86\x60\x2d\x25\x3c\xff\xf9"
        "\x1b\x82\x66\xbe\xa6\xd6\x1a\xb1",
    .ilen   = 32,
    .result = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
        "\x10\x11\x12\x13\x14\x15\x16\x17"
        "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .rlen   = 32,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  { /* From NIST SP800-38A */
    .key  = "\x8e\x73\xb0\xf7\xda\x0e\x64\x52"
        "\xc8\x10\xf3\x2b\x80\x90\x79\xe5"
        "\x62\xf8\xea\xd2\x52\x2c\x6b\x7b",
    .klen = 24,
    .iv = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .input  = "\x4f\x02\x1d\xb2\x43\xbc\x63\x3d"
        "\x71\x78\x18\x3a\x9f\xa0\x71\xe8"
        "\xb4\xd9\xad\xa9\xad\x7d\xed\xf4"
        "\xe5\xe7\x38\x76\x3f\x69\x14\x5a"
        "\x57\x1b\x24\x20\x12\xfb\x7a\xe0"
        "\x7f\xa9\xba\xac\x3d\xf1\x02\xe0"
        "\x08\xb0\xe2\x79\x88\x59\x88\x81"
        "\xd9\x20\xa9\xe6\x4f\x56\x15\xcd",
    .ilen = 64,
    .result = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x60\x3d\xeb\x10\x15\xca\x71\xbe"
        "\x2b\x73\xae\xf0\x85\x7d\x77\x81"
        "\x1f\x35\x2c\x07\x3b\x61\x08\xd7"
        "\x2d\x98\x10\xa3\x09\x14\xdf\xf4",
    .klen = 32,
    .iv = "\x00\x01\x02\x03\x04\x05\x06\x07"
        "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .input  = "\xf5\x8c\x4c\x04\xd6\xe5\xf1\xba"
        "\x77\x9e\xab\xfb\x5f\x7b\xfb\xd6"
        "\x9c\xfc\x4e\x96\x7e\xdb\x80\x8d"
        "\x67\x9f\x77\x7b\xc6\x70\x2c\x7d"
        "\x39\xf2\x33\x69\xa9\xd9\xba\xcf"
        "\xa5\x30\xe2\x63\x04\x23\x14\x61"
        "\xb2\xeb\x05\xe2\xc3\x9b\xe9\xfc"
        "\xda\x6c\x19\x07\x8c\x6a\x9d\x1b",
    .ilen = 64,
    .result = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .rlen = 64,
  },
#endif
};

static struct cipher_testvec aes_ctr_enc_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From NIST Special Publication 800-38A, Appendix F.5 */
    .key  = "\x2b\x7e\x15\x16\x28\xae\xd2\xa6"
        "\xab\xf7\x15\x88\x09\xcf\x4f\x3c",
    .klen = 16,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .ilen = 64,
    .result = "\x87\x4d\x61\x91\xb6\x20\xe3\x26"
        "\x1b\xef\x68\x64\x99\x0d\xb6\xce"
        "\x98\x06\xf6\x6b\x79\x70\xfd\xff"
        "\x86\x17\x18\x7b\xb9\xff\xfd\xff"
        "\x5a\xe4\xdf\x3e\xdb\xd5\xd3\x5e"
        "\x5b\x4f\x09\x02\x0d\xb0\x3e\xab"
        "\x1e\x03\x1d\xda\x2f\xbe\x03\xd1"
        "\x79\x21\x70\xa0\xf3\x00\x9c\xee",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  {
    .key  = "\x8e\x73\xb0\xf7\xda\x0e\x64\x52"
        "\xc8\x10\xf3\x2b\x80\x90\x79\xe5"
        "\x62\xf8\xea\xd2\x52\x2c\x6b\x7b",
    .klen = 24,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .ilen = 64,
    .result = "\x1a\xbc\x93\x24\x17\x52\x1c\xa2"
        "\x4f\x2b\x04\x59\xfe\x7e\x6e\x0b"
        "\x09\x03\x39\xec\x0a\xa6\xfa\xef"
        "\xd5\xcc\xc2\xc6\xf4\xce\x8e\x94"
        "\x1e\x36\xb2\x6b\xd1\xeb\xc6\x70"
        "\xd1\xbd\x1d\x66\x56\x20\xab\xf7"
        "\x4f\x78\xa7\xf6\xd2\x98\x09\x58"
        "\x5a\x97\xda\xec\x58\xc6\xb0\x50",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x60\x3d\xeb\x10\x15\xca\x71\xbe"
        "\x2b\x73\xae\xf0\x85\x7d\x77\x81"
        "\x1f\x35\x2c\x07\x3b\x61\x08\xd7"
        "\x2d\x98\x10\xa3\x09\x14\xdf\xf4",
    .klen = 32,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .ilen = 64,
    .result = "\x60\x1e\xc3\x13\x77\x57\x89\xa5"
        "\xb7\xa7\xf5\x04\xbb\xf3\xd2\x28"
        "\xf4\x43\xe3\xca\x4d\x62\xb5\x9a"
        "\xca\x84\xe9\x90\xca\xca\xf5\xc5"
        "\x2b\x09\x30\xda\xa2\x3d\xe9\x4c"
        "\xe8\x70\x17\xba\x2d\x84\x98\x8d"
        "\xdf\xc9\xc5\x8d\xb6\x7a\xad\xa6"
        "\x13\xc2\xdd\x08\x45\x79\x41\xa6",
    .rlen = 64,
  }
#endif
};

static struct cipher_testvec aes_ctr_dec_tv_template[] =
{
#ifndef CONFIG_CRYPTO_AES128_DISABLE
  { /* From NIST Special Publication 800-38A, Appendix F.5 */
    .key  = "\x2b\x7e\x15\x16\x28\xae\xd2\xa6"
        "\xab\xf7\x15\x88\x09\xcf\x4f\x3c",
    .klen = 16,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x87\x4d\x61\x91\xb6\x20\xe3\x26"
        "\x1b\xef\x68\x64\x99\x0d\xb6\xce"
        "\x98\x06\xf6\x6b\x79\x70\xfd\xff"
        "\x86\x17\x18\x7b\xb9\xff\xfd\xff"
        "\x5a\xe4\xdf\x3e\xdb\xd5\xd3\x5e"
        "\x5b\x4f\x09\x02\x0d\xb0\x3e\xab"
        "\x1e\x03\x1d\xda\x2f\xbe\x03\xd1"
        "\x79\x21\x70\xa0\xf3\x00\x9c\xee",
    .ilen = 64,
    .result = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES192_DISABLE
  {
    .key  = "\x8e\x73\xb0\xf7\xda\x0e\x64\x52"
        "\xc8\x10\xf3\x2b\x80\x90\x79\xe5"
        "\x62\xf8\xea\xd2\x52\x2c\x6b\x7b",
    .klen = 24,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x1a\xbc\x93\x24\x17\x52\x1c\xa2"
        "\x4f\x2b\x04\x59\xfe\x7e\x6e\x0b"
        "\x09\x03\x39\xec\x0a\xa6\xfa\xef"
        "\xd5\xcc\xc2\xc6\xf4\xce\x8e\x94"
        "\x1e\x36\xb2\x6b\xd1\xeb\xc6\x70"
        "\xd1\xbd\x1d\x66\x56\x20\xab\xf7"
        "\x4f\x78\xa7\xf6\xd2\x98\x09\x58"
        "\x5a\x97\xda\xec\x58\xc6\xb0\x50",
    .ilen = 64,
    .result = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .rlen = 64,
  },
#endif
#ifndef CONFIG_CRYPTO_AES256_DISABLE
  {
    .key  = "\x60\x3d\xeb\x10\x15\xca\x71\xbe"
        "\x2b\x73\xae\xf0\x85\x7d\x77\x81"
        "\x1f\x35\x2c\x07\x3b\x61\x08\xd7"
        "\x2d\x98\x10\xa3\x09\x14\xdf\xf4",
    .klen = 32,
    .iv = "\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7"
        "\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff",
    .input  = "\x60\x1e\xc3\x13\x77\x57\x89\xa5"
        "\xb7\xa7\xf5\x04\xbb\xf3\xd2\x28"
        "\xf4\x43\xe3\xca\x4d\x62\xb5\x9a"
        "\xca\x84\xe9\x90\xca\xca\xf5\xc5"
        "\x2b\x09\x30\xda\xa2\x3d\xe9\x4c"
        "\xe8\x70\x17\xba\x2d\x84\x98\x8d"
        "\xdf\xc9\xc5\x8d\xb6\x7a\xad\xa6"
        "\x13\xc2\xdd\x08\x45\x79\x41\xa6",
    .ilen = 64,
    .result = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
        "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
        "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
        "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
        "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
        "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
        "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
        "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .rlen = 64,
  }
#endif
};

#endif /* CONFIG_CRYPTO_AES */
#endif /* __CRYPTO_TESTMNGR_H */
