/****************************************************************************
 * arch/arm/src/at32/hardware/at32f43xxx_pinmap.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_AT32_HARDWARE_AT32F43XXX_PINMAP_H
#define __ARCH_ARM_SRC_AT32_HARDWARE_AT32F43XXX_PINMAP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include "at32_gpio.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Alternate Pin Functions.
 * All members of the AT32F43xxx family share the same pin multiplexing
 * (although they may differ in the pins physically available).
 *
 * Alternative pin selections are provided with a numeric suffix like _1, _2,
 * etc. Drivers, however, will use the pin selection without the numeric
 * suffix. Additional definitions are required in the board.h file.  For
 * example, if CAN1_RX connects via PA11 on some board, then the following
 * definitions should appear in the board.h header file for that board:
 *
 * #define GPIO_CAN1_RX GPIO_CAN1_RX_1
 *
 * The driver will then automatically configure PA11 as the CAN1 RX pin.
 */

/* WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 * Additional effort is required to select specific GPIO options such as
 * frequency, open-drain/push-pull, and pull-up/down!
 *  Just the basics are defined for most pins in this file.
 */

/* ADC */

#define GPIO_ADC1_IN0         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC1_IN1         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC1_IN2         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC1_IN3         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC1_IN4         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_ADC1_IN5         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ADC1_IN6         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN6)
#define GPIO_ADC1_IN7         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ADC1_IN8         (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ADC1_IN9         (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ADC1_IN10        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC1_IN11        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC1_IN12        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC1_IN13        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC1_IN14        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ADC1_IN15        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN5)

#define GPIO_ADC2_IN0         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC2_IN1         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC2_IN2         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC2_IN3         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC2_IN4         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_ADC2_IN5         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)
#define GPIO_ADC2_IN6         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN6)
#define GPIO_ADC2_IN7         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN7)
#define GPIO_ADC2_IN8         (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN0)
#define GPIO_ADC2_IN9         (GPIO_ANALOG|GPIO_PORTB|GPIO_PIN1)
#define GPIO_ADC2_IN10        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC2_IN11        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC2_IN12        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC2_IN13        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC2_IN14        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN4)
#define GPIO_ADC2_IN15        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN5)

#define GPIO_ADC3_IN0         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN0)
#define GPIO_ADC3_IN1         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN1)
#define GPIO_ADC3_IN2         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN2)
#define GPIO_ADC3_IN3         (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN3)
#define GPIO_ADC3_IN4         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN6)
#define GPIO_ADC3_IN5         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN7)
#define GPIO_ADC3_IN6         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN8)
#define GPIO_ADC3_IN7         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN9)
#define GPIO_ADC3_IN8         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN10)
#define GPIO_ADC3_IN9         (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN3)
#define GPIO_ADC3_IN10        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN0)
#define GPIO_ADC3_IN11        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN1)
#define GPIO_ADC3_IN12        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN2)
#define GPIO_ADC3_IN13        (GPIO_ANALOG|GPIO_PORTC|GPIO_PIN3)
#define GPIO_ADC3_IN14        (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN4)
#define GPIO_ADC3_IN15        (GPIO_ANALOG|GPIO_PORTF|GPIO_PIN5)

/* CAN */

#define GPIO_CAN1_RX_1        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_CAN1_RX_2        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_CAN1_RX_3        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN0)
#define GPIO_CAN1_RX_4        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN0)
#define GPIO_CAN1_TX_1        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN12)
#define GPIO_CAN1_TX_2        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_CAN1_TX_3        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN1)
#define GPIO_CAN1_TX_4        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN1)

#define GPIO_CAN2_RX_1        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_CAN2_RX_2        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_CAN2_RX_3        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#define GPIO_CAN2_TX_1        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#define GPIO_CAN2_TX_2        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_CAN2_TX_3        (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN12)

/* DAC - "Once the DAC channelx is enabled, the corresponding GPIO pin
 * (PA4 or PA5) is automatically connected to the analog converter output
 * (DAC_OUTx). In order to avoid parasitic consumption, the PA4 or PA5 pin
 * should first be configured to analog (AIN)".
 */

#define GPIO_DAC1_OUT1        (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN4)
#define GPIO_DAC1_OUT2        (GPIO_ANALOG|GPIO_PORTA|GPIO_PIN5)

/* Digital Camera Interface (DCMI) */

#define GPIO_DCMI_D0_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN9)
#define GPIO_DCMI_D0_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN6)
#define GPIO_DCMI_D1_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN10)
#define GPIO_DCMI_D1_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN7)
#define GPIO_DCMI_D2_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN8)
#define GPIO_DCMI_D2_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN0)
#define GPIO_DCMI_D2_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN11)
#define GPIO_DCMI_D2_4        (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN10)
#define GPIO_DCMI_D3_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN9)
#define GPIO_DCMI_D3_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN1)
#define GPIO_DCMI_D3_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN12)
#define GPIO_DCMI_D3_4        (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN11)
#define GPIO_DCMI_D4_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN11)
#define GPIO_DCMI_D4_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN4)
#define GPIO_DCMI_D4_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN3)
#define GPIO_DCMI_D5_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN6)
#define GPIO_DCMI_D5_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN4)
#define GPIO_DCMI_D5_3        (GPIO_ALT|GPIO_AF13|GPIO_PORTD|GPIO_PIN3)
#define GPIO_DCMI_D6_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN8)
#define GPIO_DCMI_D6_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN5)
#define GPIO_DCMI_D7_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN9)
#define GPIO_DCMI_D7_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN6)
#define GPIO_DCMI_D8_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN10)
#define GPIO_DCMI_D9_1        (GPIO_ALT|GPIO_AF13|GPIO_PORTC|GPIO_PIN12)
#define GPIO_DCMI_D9_2        (GPIO_ALT|GPIO_AF13|GPIO_PORTE|GPIO_PIN3)
#define GPIO_DCMI_D10_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN5)
#define GPIO_DCMI_D10_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTD|GPIO_PIN6)
#define GPIO_DCMI_D11_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTD|GPIO_PIN2)
#define GPIO_DCMI_D11_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTF|GPIO_PIN10)
#define GPIO_DCMI_D12_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTF|GPIO_PIN11)
#define GPIO_DCMI_D12_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN6)
#define GPIO_DCMI_D13_1       (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN15)
#define GPIO_DCMI_D13_2       (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN7)
#define GPIO_DCMI_HSYNC_1     (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN4)
#define GPIO_DCMI_PIXCLK      (GPIO_ALT|GPIO_AF13|GPIO_PORTA|GPIO_PIN6)
#define GPIO_DCMI_VSYNC_1     (GPIO_ALT|GPIO_AF13|GPIO_PORTB|GPIO_PIN7)
#define GPIO_DCMI_VSYNC_2     (GPIO_ALT|GPIO_AF13|GPIO_PORTG|GPIO_PIN9)

/* Clocks outputs */

#define GPIO_MCO1             (GPIO_ALT|GPIO_AF0|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_MCO2             (GPIO_ALT|GPIO_AF0|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)

/* Ethernet MAC */

#if defined(CONFIG_AT32_AT32F437)
#  define GPIO_ETH_MDC          (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN1)
#  define GPIO_ETH_MDIO         (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#  define GPIO_ETH_MII_COL_1    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#  define GPIO_ETH_MII_COL_2    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN3)
#  define GPIO_ETH_MII_CRS_1    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#  define GPIO_ETH_MII_CRS_2    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN2)
#  define GPIO_ETH_MII_RXD0     (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#  define GPIO_ETH_MII_RXD1     (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#  define GPIO_ETH_MII_RXD2_1   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#  define GPIO_ETH_MII_RXD2_2   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN6)
#  define GPIO_ETH_MII_RXD3_1   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#  define GPIO_ETH_MII_RXD3_2   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN7)
#  define GPIO_ETH_MII_RX_CLK   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#  define GPIO_ETH_MII_RX_DV    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#  define GPIO_ETH_MII_RX_ER_1  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#  define GPIO_ETH_MII_RX_ER_2  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTI|GPIO_PIN10)
#  define GPIO_ETH_MII_TXD0_1   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#  define GPIO_ETH_MII_TXD0_2   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#  define GPIO_ETH_MII_TXD1_1   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#  define GPIO_ETH_MII_TXD1_2   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#  define GPIO_ETH_MII_TXD2     (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#  define GPIO_ETH_MII_TXD3_1   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#  define GPIO_ETH_MII_TXD3_2   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN2)
#  define GPIO_ETH_MII_TX_CLK   (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN3)
#  define GPIO_ETH_MII_TX_EN_1  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#  define GPIO_ETH_MII_TX_EN_2  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#  define GPIO_ETH_PPS_OUT_1    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#  define GPIO_ETH_PPS_OUT_2    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN8)
#  define GPIO_ETH_RMII_CRS_DV  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#  define GPIO_ETH_RMII_REF_CLK (GPIO_ALT|GPIO_AF11|GPIO_PORTA|GPIO_PIN1)
#  define GPIO_ETH_RMII_RXD0    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)
#  define GPIO_ETH_RMII_RXD1    (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#  define GPIO_ETH_RMII_TXD0_1  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#  define GPIO_ETH_RMII_TXD0_2  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN13)
#  define GPIO_ETH_RMII_TXD1_1  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#  define GPIO_ETH_RMII_TXD1_2  (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#  define GPIO_ETH_RMII_TX_EN_1 (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#  define GPIO_ETH_RMII_TX_EN_2 (GPIO_ALT|GPIO_AF11|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN11)
#endif

/* Flexible Memory Controller (FMC) */
#if 0
#define GPIO_FMC_A0          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN0)
#define GPIO_FMC_A1          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN1)
#define GPIO_FMC_A2          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN2)
#define GPIO_FMC_A3          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN3)
#define GPIO_FMC_A4          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN4)
#define GPIO_FMC_A5          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN5)
#define GPIO_FMC_A6          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN12)
#define GPIO_FMC_A7          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN13)
#define GPIO_FMC_A8          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN14)
#define GPIO_FMC_A9          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN15)
#define GPIO_FMC_A10         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN0)
#define GPIO_FMC_A11         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN1)
#define GPIO_FMC_A12         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN2)
#define GPIO_FMC_A13         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN3)
#define GPIO_FMC_A14         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN4)
#define GPIO_FMC_A15         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN5)
#define GPIO_FMC_A16         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN11)
#define GPIO_FMC_A17         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN12)
#define GPIO_FMC_A18         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN13)
#define GPIO_FMC_A19         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN3)
#define GPIO_FMC_A20         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN4)
#define GPIO_FMC_A21         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN5)
#define GPIO_FMC_A22         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN6)
#define GPIO_FMC_A23         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN2)
#define GPIO_FMC_A24         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN13)
#define GPIO_FMC_A25         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN14)
#define GPIO_FMC_NBL1        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN1)
#define GPIO_FMC_CLK         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN3)
#define GPIO_FMC_D0          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN14)
#define GPIO_FMC_D1          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN15)
#define GPIO_FMC_D2          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN0)
#define GPIO_FMC_D3          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN1)
#define GPIO_FMC_D4          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN7)
#define GPIO_FMC_D5          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN8)
#define GPIO_FMC_D6          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN9)
#define GPIO_FMC_D7          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN10)
#define GPIO_FMC_D8          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN11)
#define GPIO_FMC_D9          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN12)
#define GPIO_FMC_D10         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN13)
#define GPIO_FMC_D11         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN14)
#define GPIO_FMC_D12         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN15)
#define GPIO_FMC_D13         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN8)
#define GPIO_FMC_D14         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN9)
#define GPIO_FMC_D15         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN10)
#define GPIO_FMC_NBL0        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN0)
#define GPIO_FMC_NE1         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN7)
#define GPIO_FMC_NE2         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN9)
#define GPIO_FMC_NE3         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN10)
#define GPIO_FMC_NE4         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN12)
#define GPIO_FMC_NL          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTB|GPIO_PIN7)
#define GPIO_FMC_NOE         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN4)
#define GPIO_FMC_NWAIT       (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN6)
#define GPIO_FMC_NWE         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN5)

#define GPIO_FMC_INT3        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN7)
#define GPIO_FMC_NCE3        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN9)

/* Flexible Static Memory Controller (FSMC) */

#define GPIO_FSMC_A0          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN0)
#define GPIO_FSMC_A1          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN1)
#define GPIO_FSMC_A2          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN2)
#define GPIO_FSMC_A3          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN3)
#define GPIO_FSMC_A4          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN4)
#define GPIO_FSMC_A5          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN5)
#define GPIO_FSMC_A6          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN12)
#define GPIO_FSMC_A7          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN13)
#define GPIO_FSMC_A8          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN14)
#define GPIO_FSMC_A9          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTF|GPIO_PIN15)
#define GPIO_FSMC_A10         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN0)
#define GPIO_FSMC_A11         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN1)
#define GPIO_FSMC_A12         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN2)
#define GPIO_FSMC_A13         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN3)
#define GPIO_FSMC_A14         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN4)
#define GPIO_FSMC_A15         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN5)
#define GPIO_FSMC_A16         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN11)
#define GPIO_FSMC_A17         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN12)
#define GPIO_FSMC_A18         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN13)
#define GPIO_FSMC_A19         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN3)
#define GPIO_FSMC_A20         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN4)
#define GPIO_FSMC_A21         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN5)
#define GPIO_FSMC_A22         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN6)
#define GPIO_FSMC_A23         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN2)
#define GPIO_FSMC_A24         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN13)
#define GPIO_FSMC_A25         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN14)
#define GPIO_FSMC_NBL1        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN1)
#define GPIO_FSMC_CLK         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN3)
#define GPIO_FSMC_D0          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN14)
#define GPIO_FSMC_D1          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN15)
#define GPIO_FSMC_D2          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN0)
#define GPIO_FSMC_D3          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN1)
#define GPIO_FSMC_D4          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN7)
#define GPIO_FSMC_D5          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN8)
#define GPIO_FSMC_D6          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN9)
#define GPIO_FSMC_D7          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN10)
#define GPIO_FSMC_D8          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN11)
#define GPIO_FSMC_D9          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN12)
#define GPIO_FSMC_D10         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN13)
#define GPIO_FSMC_D11         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN14)
#define GPIO_FSMC_D12         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN15)
#define GPIO_FSMC_D13         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN8)
#define GPIO_FSMC_D14         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN9)
#define GPIO_FSMC_D15         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN10)
#define GPIO_FSMC_NBL0        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTE|GPIO_PIN0)
#define GPIO_FSMC_NE1         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN7)
#define GPIO_FSMC_NE2         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN9)
#define GPIO_FSMC_NE3         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN10)
#define GPIO_FSMC_NE4         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN12)
#define GPIO_FSMC_NL          (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTB|GPIO_PIN7)
#define GPIO_FSMC_NOE         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN4)
#define GPIO_FSMC_NWAIT       (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN6)
#define GPIO_FSMC_NWE         (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTD|GPIO_PIN5)

#define GPIO_FSMC_INT3        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN7)
#define GPIO_FSMC_NCE3        (GPIO_ALT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PORTG|GPIO_PIN9)
#endif

/* I2C */

#define GPIO_I2C1_SCL_1       (GPIO_ALT|GPIO_AF8|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN9)
#define GPIO_I2C1_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN6)
#define GPIO_I2C1_SCL_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN8)
#define GPIO_I2C1_SCL_4       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN6)
#define GPIO_I2C1_SCL_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN1)
#define GPIO_I2C1_SDA_1       (GPIO_ALT|GPIO_AF8|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN10)
#define GPIO_I2C1_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN7)
#define GPIO_I2C1_SDA_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2C1_SDA_4       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN7)
#define GPIO_I2C1_SDA_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN0)
#define GPIO_I2C1_SMBA_1      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_I2C1_SMBA_2      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)

#define GPIO_I2C2_SCL_1       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN10)
#define GPIO_I2C2_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN1)
#define GPIO_I2C2_SCL_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN2)
#define GPIO_I2C2_SCL_4       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN0)
#define GPIO_I2C2_SCL_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN11)
#define GPIO_I2C2_SCL_6       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN12)
#define GPIO_I2C2_SDA_1       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN1)
#define GPIO_I2C2_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN12)
#define GPIO_I2C2_SDA_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN3)
#define GPIO_I2C2_SDA_4       (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN9)
#define GPIO_I2C2_SDA_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN11)
#define GPIO_I2C2_SDA_6       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN12)
#define GPIO_I2C2_SDA_7       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN13)
#define GPIO_I2C2_SDA_8       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN0)
#define GPIO_I2C2_SDA_9       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTH|GPIO_PIN3)
#define GPIO_I2C2_SMBA_1      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_I2C2_SMBA_2      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN2)
#define GPIO_I2C2_SMBA_3      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN11)

#define GPIO_I2C3_SCL_1       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN8)
#define GPIO_I2C3_SCL_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN15)
#define GPIO_I2C3_SCL_3       (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN13)
#define GPIO_I2C3_SCL_4       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN0)
#define GPIO_I2C3_SCL_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN14)
#define GPIO_I2C3_SCL_6       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN14)
#define GPIO_I2C3_SDA_1       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN4)
#define GPIO_I2C3_SDA_2       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN14)
#define GPIO_I2C3_SDA_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN1)
#define GPIO_I2C3_SDA_4       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTC|GPIO_PIN9)
#define GPIO_I2C3_SDA_5       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTD|GPIO_PIN15)
#define GPIO_I2C3_SDA_6       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_OPENDRAIN|GPIO_PORTF|GPIO_PIN15)
#define GPIO_I2C3_SMBA_1      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_I2C3_SMBA_2      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN2)
#define GPIO_I2C3_SMBA_3      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)
#define GPIO_I2C3_SMBA_4      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN13)

/* JTAG */

#define GPIO_JTCK_SWCLK       (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN14)
#define GPIO_JTDI             (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN15)
#define GPIO_JTDO             (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN3)
#define GPIO_JTMS_SWDIO       (GPIO_ALT|GPIO_AF0|GPIO_PORTA|GPIO_PIN13)
#define GPIO_JTRST            (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN4)

/* OTG FS/HS (VBUS PA9 is not an alternate configuration) */

#define GPIO_OTGFS_DM         (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_OTGFS_DP         (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN12)
#define GPIO_OTGFS_ID         (GPIO_ALT|GPIO_PULLUP|GPIO_AF10|GPIO_DRV_STRONG|GPIO_OPENDRAIN|GPIO_PORTA|GPIO_PIN10)
#define GPIO_OTGFS_SOF        (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_OTGFS_VBUS       (GPIO_ALT|GPIO_FLOAT|GPIO_AF10|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)

#define GPIO_OTGFS2_DM         (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)
#define GPIO_OTGFS2_DP         (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)
#define GPIO_OTGFS2_ID         (GPIO_ALT|GPIO_PULLUP|GPIO_AF12|GPIO_DRV_STRONG|GPIO_OPENDRAIN|GPIO_PORTB|GPIO_PIN12)
#define GPIO_OTGFS2_SOF        (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN4)
#define GPIO_OTGFS2_VBUS       (GPIO_ALT|GPIO_FLOAT|GPIO_AF12|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN13)

/* RTC */

#define GPIO_RTC_50HZ         (GPIO_ALT|GPIO_AF0|GPIO_PORTC|GPIO_PIN15)

/* SDIO
 *
 * Note that the below configures GPIO_DRV_MODETATE I/O, that means for using
 * the SDIO that you must enable I/O Compensation via the configuration
 * option CONFIG_AT32_SYSCFG_IOCOMPENSATION=y.
 */

#define GPIO_SDIO_CMD_1       (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN2)
#define GPIO_SDIO_CMD_2       (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SDIO_CK_1        (GPIO_ALT|GPIO_AF12|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SDIO_CK_2        (GPIO_ALT|GPIO_AF12|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN2)
#define GPIO_SDIO_CK_3        (GPIO_ALT|GPIO_AF13|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN15)
#define GPIO_SDIO_D0_1        (GPIO_ALT|GPIO_AF14|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_SDIO_D0_2        (GPIO_ALT|GPIO_AF14|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)
#define GPIO_SDIO_D0_3        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_SDIO_D0_4        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SDIO_D1_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_SDIO_D1_2        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_SDIO_D1_3        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_SDIO_D2_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_SDIO_D2_2        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_SDIO_D2_3        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#define GPIO_SDIO_D3_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_SDIO_D3_2        (GPIO_ALT|GPIO_AF14|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SDIO_D4_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_SDIO_D5_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SDIO_D6_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_SDIO_D6_2        (GPIO_ALT|GPIO_AF13|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)
#define GPIO_SDIO_D7_1        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_SDIO_D7_2        (GPIO_ALT|GPIO_AF12|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_SDIO2_CMD_1      (GPIO_ALT|GPIO_AF13|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_SDIO2_CMD_2      (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_SDIO2_CK_1       (GPIO_ALT|GPIO_AF13|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN4)
#define GPIO_SDIO2_CK_2       (GPIO_ALT|GPIO_AF10|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN2)
#define GPIO_SDIO2_D0_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN0)
#define GPIO_SDIO2_D0_2       (GPIO_ALT|GPIO_AF11|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SDIO2_D1_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN1)
#define GPIO_SDIO2_D1_2       (GPIO_ALT|GPIO_AF11|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SDIO2_D2_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#define GPIO_SDIO2_D2_2       (GPIO_ALT|GPIO_AF11|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SDIO2_D3_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN3)
#define GPIO_SDIO2_D3_2       (GPIO_ALT|GPIO_AF13|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_SDIO2_D4_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SDIO2_D5_1       (GPIO_ALT|GPIO_AF10|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SDIO2_D6_1       (GPIO_ALT|GPIO_AF14|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SDIO2_D7_1       (GPIO_ALT|GPIO_AF14|GPIO_PULLUP|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)

/* SPI */

#define GPIO_SPI1_MISO_1      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN6)
#define GPIO_SPI1_MISO_2      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI1_MISO_3      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN14)
#define GPIO_SPI1_MISO_4      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN0)
#define GPIO_SPI1_MOSI_1      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN7)
#define GPIO_SPI1_MOSI_2      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI1_MOSI_3      (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN15)
#define GPIO_SPI1_MOSI_4      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN1)
#define GPIO_SPI1_NSS_1       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI1_NSS_2       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI1_NSS_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN12)
#define GPIO_SPI1_SCK_1       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN5)
#define GPIO_SPI1_SCK_2       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI1_SCK_3       (GPIO_ALT|GPIO_AF4|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN13)
#define GPIO_SPI2_MISO_1      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN14)
#define GPIO_SPI2_MISO_2      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN2)
#define GPIO_SPI2_MISO_3      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN12)
#define GPIO_SPI2_MISO_4      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN3)
#define GPIO_SPI2_MOSI_1      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN15)
#define GPIO_SPI2_MOSI_2      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN3)
#define GPIO_SPI2_MOSI_3      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN10)
#define GPIO_SPI2_MOSI_4      (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN1)
#define GPIO_SPI2_MOSI_5      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN4)
#define GPIO_SPI2_NSS_1       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN12)
#define GPIO_SPI2_NSS_2       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SPI2_NSS_3       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN11)
#define GPIO_SPI2_NSS_4       (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN0)
#define GPIO_SPI2_NSS_5       (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN1)
#define GPIO_SPI2_SCK_1       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN10)
#define GPIO_SPI2_SCK_2       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN13)
#define GPIO_SPI2_SCK_3       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN9)
#define GPIO_SPI2_SCK_4       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN1)
#define GPIO_SPI2_SCK_5       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN7)
#define GPIO_SPI2_SCK_6       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN1)
#define GPIO_SPI2_SCK_7       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN3)
#define GPIO_SPI3_MISO_1      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN4)
#define GPIO_SPI3_MISO_2      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN11)
#define GPIO_SPI3_MISO_3      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN13)
#define GPIO_SPI3_MOSI_1      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN5)
#define GPIO_SPI3_MOSI_2      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN12)
#define GPIO_SPI3_MOSI_3      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN14)
#define GPIO_SPI3_MOSI_4      (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN0)
#define GPIO_SPI3_MOSI_5      (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN2)
#define GPIO_SPI3_MOSI_6      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN1)
#define GPIO_SPI3_MOSI_7      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN0)
#define GPIO_SPI3_MOSI_8      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN6)
#define GPIO_SPI3_NSS_1       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN15)
#define GPIO_SPI3_NSS_2       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN4)
#define GPIO_SPI3_SCK_1       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN3)
#define GPIO_SPI3_SCK_2       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTC|GPIO_PIN10)
#define GPIO_SPI3_SCK_3       (GPIO_ALT|GPIO_AF7|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN12)
#define GPIO_SPI4_MISO_1      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN11)
#define GPIO_SPI4_MISO_2      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN8)
#define GPIO_SPI4_MISO_3      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTD|GPIO_PIN0)
#define GPIO_SPI4_MISO_4      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN5)
#define GPIO_SPI4_MISO_5      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN13)
#define GPIO_SPI4_MISO_6      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN12)
#define GPIO_SPI4_MOSI_1      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTA|GPIO_PIN1)
#define GPIO_SPI4_MOSI_2      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN9)
#define GPIO_SPI4_MOSI_3      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN6)
#define GPIO_SPI4_MOSI_4      (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN14)
#define GPIO_SPI4_MOSI_5      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN13)
#define GPIO_SPI4_SCK_1       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN7)
#define GPIO_SPI4_SCK_2       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN13)
#define GPIO_SPI4_SCK_3       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN2)
#define GPIO_SPI4_SCK_4       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN12)
#define GPIO_SPI4_SCK_5       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN11)
#define GPIO_SPI4_NSS_1       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN6)
#define GPIO_SPI4_NSS_2       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTB|GPIO_PIN12)
#define GPIO_SPI4_NSS_3       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN4)
#define GPIO_SPI4_NSS_4       (GPIO_ALT|GPIO_AF5|GPIO_DRV_MODETATE|GPIO_PORTE|GPIO_PIN11)
#define GPIO_SPI4_NSS_5       (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PORTG|GPIO_PIN14)

/* Timers */

#define GPIO_TIM1_BKIN_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM1_BKIN_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN12)
#define GPIO_TIM1_BKIN_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN15)
#define GPIO_TIM1_CH1N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM1_CH1N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN13)
#define GPIO_TIM1_CH1N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN8)
#define GPIO_TIM1_CH1IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN8)
#define GPIO_TIM1_CH1IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN9)
#define GPIO_TIM1_CH1OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_TIM1_CH1OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN9)
#define GPIO_TIM1_CH2N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM1_CH2N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM1_CH2N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN10)
#define GPIO_TIM1_CH2N_4      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN1)
#define GPIO_TIM1_CH2IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN9)
#define GPIO_TIM1_CH2IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN11)
#define GPIO_TIM1_CH2OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_TIM1_CH2OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN11)
#define GPIO_TIM1_CH3N_1      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM1_CH3N_2      (GPIO_ALT|GPIO_AF1|GPIO_PORTB|GPIO_PIN15)
#define GPIO_TIM1_CH3N_3      (GPIO_ALT|GPIO_AF1|GPIO_PORTE|GPIO_PIN12)
#define GPIO_TIM1_CH3IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN10)
#define GPIO_TIM1_CH3IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN13)
#define GPIO_TIM1_CH3OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN10)
#define GPIO_TIM1_CH3OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN13)
#define GPIO_TIM1_CH4IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN11)
#define GPIO_TIM1_CH4IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN14)
#define GPIO_TIM1_CH4OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)
#define GPIO_TIM1_CH4OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN14)
#define GPIO_TIM1_ETR_1       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN12)
#define GPIO_TIM1_ETR_2       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN7)
#define GPIO_TIM1_ETR_3       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN10)

#define GPIO_TIM2_CH1IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_CH1IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_CH1IN_3     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM2_CH1IN_4     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM2_CH1OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_CH1OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_CH1OUT_3    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM2_CH1OUT_4    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM2_CH2IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM2_CH2IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN3)
#define GPIO_TIM2_CH2IN_3     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM2_CH2OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM2_CH2OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN3)
#define GPIO_TIM2_CH2OUT_3    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM2_CH3IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM2_CH3IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN10)
#define GPIO_TIM2_CH3OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM2_CH3OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_TIM2_CH4IN_1     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM2_CH4IN_2     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM2_CH4IN_3     (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN2)
#define GPIO_TIM2_CH4OUT_1    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM2_CH4OUT_2    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM2_CH4OUT_3    (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN2)
#define GPIO_TIM2_ETR_1       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM2_ETR_2       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN15)
#define GPIO_TIM2_ETR_3       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM2_ETR_4       (GPIO_ALT|GPIO_AF1|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)

#define GPIO_TIM3_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM3_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN4)
#define GPIO_TIM3_CH1IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM3_CH1IN_4     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TIM3_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM3_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN4)
#define GPIO_TIM3_CH1OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM3_CH1OUT_4    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TIM3_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM3_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN5)
#define GPIO_TIM3_CH2IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM3_CH2IN_4     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN4)
#define GPIO_TIM3_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM3_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_TIM3_CH2OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM3_CH2OUT_4    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN4)
#define GPIO_TIM3_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM3_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM3_CH3IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM3_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM3_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM3_CH3OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM3_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM3_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM3_CH4IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TIM3_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM3_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM3_CH4OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TIM3_ETR_1       (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN2)
#define GPIO_TIM3_ETR_2       (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN2)

#define GPIO_TIM4_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN6)
#define GPIO_TIM4_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN12)
#define GPIO_TIM4_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_TIM4_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN12)
#define GPIO_TIM4_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN7)
#define GPIO_TIM4_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN13)
#define GPIO_TIM4_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)
#define GPIO_TIM4_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN13)
#define GPIO_TIM4_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM4_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN14)
#define GPIO_TIM4_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM4_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN14)
#define GPIO_TIM4_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM4_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTD|GPIO_PIN15)
#define GPIO_TIM4_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM4_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN15)
#define GPIO_TIM4_ETR         (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN0)

#define GPIO_TIM5_CH1IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM5_CH1IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN2)
#define GPIO_TIM5_CH1IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN12)
#define GPIO_TIM5_CH1OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM5_CH1OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN2)
#define GPIO_TIM5_CH1OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN12)
#define GPIO_TIM5_CH2IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM5_CH2IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTH|GPIO_PIN3)
#define GPIO_TIM5_CH2IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN10)
#define GPIO_TIM5_CH2OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_TIM5_CH2OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTH|GPIO_PIN2)
#define GPIO_TIM5_CH2OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_TIM5_CH3IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM5_CH3IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN11)
#define GPIO_TIM5_CH3OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM5_CH3OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_TIM5_CH4IN_1     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM5_CH4IN_2     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM5_CH4IN_3     (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN10)
#define GPIO_TIM5_CH4OUT_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM5_CH4OUT_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_TIM5_CH4OUT_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN10)

#define GPIO_TIM8_BKIN_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM8_BKIN_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN7)
#define GPIO_TIM8_BKIN_3      (GPIO_ALT|GPIO_AF3|GPIO_PORTF|GPIO_PIN12)
#define GPIO_TIM8_CH1N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN5)
#define GPIO_TIM8_CH1N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM8_CH1IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM8_CH1OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_TIM8_CH2N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN0)
#define GPIO_TIM8_CH2N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM8_CH2IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM8_CH2OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_TIM8_CH3N_1      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN1)
#define GPIO_TIM8_CH3N_2      (GPIO_ALT|GPIO_AF3|GPIO_PORTB|GPIO_PIN15)
#define GPIO_TIM8_CH3IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM8_CH3OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM8_CH4IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM8_CH4OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_TIM8_ETR_1       (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN0)
#define GPIO_TIM8_ETR_2       (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN11)

#define GPIO_TIM9_CH1IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM9_CH1IN_2     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM9_CH1OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_TIM9_CH1OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM9_CH2IN_1     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM9_CH2IN_2     (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TIM9_CH2OUT_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_TIM9_CH2OUT_2    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN6)

#define GPIO_TIM10_CH1IN_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM10_CH1IN_2    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN6)
#define GPIO_TIM10_CH1OUT_1   (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_TIM10_CH1OUT_2   (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN6)

#define GPIO_TIM11_CH1IN_1    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM11_CH1IN_2    (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN7)
#define GPIO_TIM11_CH1OUT_1   (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_TIM11_CH1OUT_2   (GPIO_ALT|GPIO_AF3|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN7)

#define GPIO_TIM12_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM12_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN14)
#define GPIO_TIM12_CH2IN_1    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN15)
#define GPIO_TIM12_CH2OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN15)

#define GPIO_TIM13_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM13_CH1IN_2    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN8)
#define GPIO_TIM13_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN6)
#define GPIO_TIM13_CH1OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN8)

#define GPIO_TIM14_CH1IN_1    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM14_CH1IN_2    (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN9)
#define GPIO_TIM14_CH1OUT_1   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN7)
#define GPIO_TIM14_CH1OUT_2   (GPIO_ALT|GPIO_AF9|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN9)

#define GPIO_TIM20_BKIN_1     (GPIO_ALT|GPIO_AF2|GPIO_PORTF|GPIO_PIN7)
#define GPIO_TIM20_BKIN_2     (GPIO_ALT|GPIO_AF2|GPIO_PORTF|GPIO_PIN9)
#define GPIO_TIM20_BKIN_3     (GPIO_ALT|GPIO_AF2|GPIO_PORTG|GPIO_PIN3)
#define GPIO_TIM20_CH1N_1     (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN4)
#define GPIO_TIM20_CH1N_2     (GPIO_ALT|GPIO_AF2|GPIO_PORTF|GPIO_PIN4)
#define GPIO_TIM20_CH1N_3     (GPIO_ALT|GPIO_AF2|GPIO_PORTG|GPIO_PIN0)
#define GPIO_TIM20_CH1IN_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTB|GPIO_PIN2)
#define GPIO_TIM20_CH1IN_2    (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN2)
#define GPIO_TIM20_CH1IN_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN12)
#define GPIO_TIM20_CH1OUT_1   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN2)
#define GPIO_TIM20_CH1OUT_2   (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN2)
#define GPIO_TIM20_CH1OUT_3   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN12)
#define GPIO_TIM20_CH2N_1     (GPIO_ALT|GPIO_AF2|GPIO_PORTF|GPIO_PIN5)
#define GPIO_TIM20_CH2N_2     (GPIO_ALT|GPIO_AF2|GPIO_PORTG|GPIO_PIN1)
#define GPIO_TIM20_CH2N_3     (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TIM20_CH2IN_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN2)
#define GPIO_TIM20_CH2IN_2    (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TIM20_CH2IN_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN13)
#define GPIO_TIM20_CH2OUT_1   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#define GPIO_TIM20_CH2OUT_2   (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TIM20_CH2OUT_3   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN13)
#define GPIO_TIM20_CH3N_1     (GPIO_ALT|GPIO_AF2|GPIO_PORTG|GPIO_PIN2)
#define GPIO_TIM20_CH3N_2     (GPIO_ALT|GPIO_AF6|GPIO_PORTE|GPIO_PIN6)
#define GPIO_TIM20_CH3IN_1    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN2)
#define GPIO_TIM20_CH3IN_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN14)
#define GPIO_TIM20_CH3IN_3    (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM20_CH3OUT_1   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN2)
#define GPIO_TIM20_CH3OUT_2   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN14)
#define GPIO_TIM20_CH3OUT_3   (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_TIM20_CH4IN_1    (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN1)
#define GPIO_TIM20_CH4IN_2    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN3)
#define GPIO_TIM20_CH4IN_3    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN6)
#define GPIO_TIM20_CH4IN_4    (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN15)
#define GPIO_TIM20_CH4OUT_1   (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN1)
#define GPIO_TIM20_CH4OUT_2   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN3)
#define GPIO_TIM20_CH4OUT_3   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN6)
#define GPIO_TIM20_CH4OUT_4   (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN15)
#define GPIO_TIM20_ETR_1      (GPIO_ALT|GPIO_AF6|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTE|GPIO_PIN0)
#define GPIO_TIM20_ETR_2      (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTF|GPIO_PIN11)
#define GPIO_TIM20_ETR_3      (GPIO_ALT|GPIO_AF2|GPIO_DRV_MODETATE|GPIO_FLOAT|GPIO_PORTG|GPIO_PIN5)

/* Trace */

#define GPIO_TRACECLK         (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN2)
#define GPIO_TRACESWO         (GPIO_ALT|GPIO_AF0|GPIO_PORTB|GPIO_PIN3)

#define GPIO_TRACED0          (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN3)
#define GPIO_TRACED1          (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN4)

#define GPIO_TRACED2          (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN5)
#define GPIO_TRACED3          (GPIO_ALT|GPIO_AF0|GPIO_PORTE|GPIO_PIN6)

/* UARTs/USARTs */

#define GPIO_USART1_CK_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN8)
#define GPIO_USART1_CK_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN5)
#define GPIO_USART1_CTS       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN11)
#define GPIO_USART1_RTS       (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN12)
#define GPIO_USART1_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN10)
#define GPIO_USART1_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN7)
#define GPIO_USART1_RX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN3)
#define GPIO_USART1_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN9)
#define GPIO_USART1_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_USART1_TX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN15)

#define GPIO_USART2_CK_1      (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN4)
#define GPIO_USART2_CK_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN7)
#define GPIO_USART2_CTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN0)
#define GPIO_USART2_CTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN3)
#define GPIO_USART2_RTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN1)
#define GPIO_USART2_RTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN4)
#define GPIO_USART2_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN3)
#define GPIO_USART2_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN6)
#define GPIO_USART2_RX_3      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN15)
#define GPIO_USART2_RX_4      (GPIO_ALT|GPIO_AF6|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN0)
#define GPIO_USART2_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN2)
#define GPIO_USART2_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN5)
#define GPIO_USART2_TX_3      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN8)
#define GPIO_USART2_TX_4      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN14)

#define GPIO_USART3_CK_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN12)
#define GPIO_USART3_CK_2      (GPIO_ALT|GPIO_AF7|GPIO_PORTC|GPIO_PIN12)
#define GPIO_USART3_CK_3      (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN10)
#define GPIO_USART3_CK_4      (GPIO_ALT|GPIO_AF8|GPIO_PORTB|GPIO_PIN0)
#define GPIO_USART3_CTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN11)
#define GPIO_USART3_CTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTA|GPIO_PIN6)
#define GPIO_USART3_RTS_1     (GPIO_ALT|GPIO_AF7|GPIO_PORTB|GPIO_PIN14)
#define GPIO_USART3_RTS_2     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN12)
#define GPIO_USART3_RTS_3     (GPIO_ALT|GPIO_AF7|GPIO_PORTD|GPIO_PIN2)
#define GPIO_USART3_RX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN11)
#define GPIO_USART3_RX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_USART3_RX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN9)
#define GPIO_USART3_RX_4      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN5)
#define GPIO_USART3_TX_1      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN10)
#define GPIO_USART3_TX_2      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_USART3_TX_3      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN8)
#define GPIO_USART3_TX_4      (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN4)

#define GPIO_UART4_RX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN1)
#define GPIO_UART4_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN11)
#define GPIO_UART4_RX_3       (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN9)
#define GPIO_UART4_TX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN0)
#define GPIO_UART4_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN10)
#define GPIO_UART4_TX_3       (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN8)

#define GPIO_UART5_RX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN5)
#define GPIO_UART5_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN8)
#define GPIO_UART5_RX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN2)
#define GPIO_UART5_RX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN11)
#define GPIO_UART5_TX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN6)
#define GPIO_UART5_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN9)
#define GPIO_UART5_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN12)
#define GPIO_UART5_TX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN10)

#define GPIO_USART6_CK_1      (GPIO_ALT|GPIO_AF8|GPIO_PORTC|GPIO_PIN8)
#define GPIO_USART6_CK_2      (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN7)
#define GPIO_USART6_CTS_1     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN13)
#define GPIO_USART6_CTS_2     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN15)
#define GPIO_USART6_RTS_1     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN12)
#define GPIO_USART6_RTS_2     (GPIO_ALT|GPIO_AF8|GPIO_PORTG|GPIO_PIN8)
#define GPIO_USART6_RX_1      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN7)
#define GPIO_USART6_RX_2      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN9)
#define GPIO_USART6_RX_3      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN5)
#define GPIO_USART6_RX_4      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN12)
#define GPIO_USART6_TX_1      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN6)
#define GPIO_USART6_TX_2      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTG|GPIO_PIN14)
#define GPIO_USART6_TX_3      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN4)
#define GPIO_USART6_TX_4      (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTA|GPIO_PIN11)

#define GPIO_UART7_RX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN3)
#define GPIO_UART7_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN1)
#define GPIO_UART7_RX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN7)
#define GPIO_UART7_RX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN6)
#define GPIO_UART7_TX_1       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTB|GPIO_PIN4)
#define GPIO_UART7_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN0)
#define GPIO_UART7_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN8)
#define GPIO_UART7_TX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTF|GPIO_PIN7)

#define GPIO_UART8_RX_1       (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN9)
#define GPIO_UART8_RX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN3)
#define GPIO_UART8_RX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN14)
#define GPIO_UART8_RX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN0)
#define GPIO_UART8_TX_1       (GPIO_ALT|GPIO_AF7|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN8)
#define GPIO_UART8_TX_2       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTC|GPIO_PIN2)
#define GPIO_UART8_TX_3       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTD|GPIO_PIN13)
#define GPIO_UART8_TX_4       (GPIO_ALT|GPIO_AF8|GPIO_PULLUP|GPIO_DRV_STRONG|GPIO_PUSHPULL|GPIO_PORTE|GPIO_PIN1)

/* Quad SPI */

#if defined(CONFIG_AT32_AT32F435) || defined(CONFIG_AT32_AT32F437)
#  define GPIO_QUADSPI_BK1_IO0_1 (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN8)
#  define GPIO_QUADSPI_BK1_IO0_2 (GPIO_ALT|GPIO_AF9 |GPIO_PORTC|GPIO_PIN9)
#  define GPIO_QUADSPI_BK1_IO0_3 (GPIO_ALT|GPIO_AF9 |GPIO_PORTD|GPIO_PIN11)
#  define GPIO_QUADSPI_BK1_IO1_1 (GPIO_ALT|GPIO_AF10|GPIO_PORTF|GPIO_PIN9)
#  define GPIO_QUADSPI_BK1_IO1_2 (GPIO_ALT|GPIO_AF9 |GPIO_PORTC|GPIO_PIN10)
#  define GPIO_QUADSPI_BK1_IO1_3 (GPIO_ALT|GPIO_AF9 |GPIO_PORTD|GPIO_PIN12)
#  define GPIO_QUADSPI_BK1_IO2_1 (GPIO_ALT|GPIO_AF9 |GPIO_PORTE|GPIO_PIN2)
#  define GPIO_QUADSPI_BK1_IO2_2 (GPIO_ALT|GPIO_AF9 |GPIO_PORTF|GPIO_PIN7)
#  define GPIO_QUADSPI_BK1_IO3_1 (GPIO_ALT|GPIO_AF9 |GPIO_PORTA|GPIO_PIN1)
#  define GPIO_QUADSPI_BK1_IO3_2 (GPIO_ALT|GPIO_AF9 |GPIO_PORTD|GPIO_PIN13)
#  define GPIO_QUADSPI_BK1_IO3_3 (GPIO_ALT|GPIO_AF9 |GPIO_PORTF|GPIO_PIN6)
#  define GPIO_QUADSPI_BK1_NCS_1 (GPIO_ALT|GPIO_AF10|GPIO_PORTB|GPIO_PIN6)
#endif

#endif /* __ARCH_ARM_SRC_AT32_HARDWARE_AT32F43XXX_PINMAP_H */
