/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <Windows.h>

#include <memory>

namespace org::apache::nifi::minifi::wel {

struct unique_evt_handle_deleter {
  void operator()(EVT_HANDLE event) const noexcept { EvtClose(event); }
};

using unique_evt_handle = std::unique_ptr<std::remove_pointer<EVT_HANDLE>::type, unique_evt_handle_deleter>;

}  // namespace org::apache::nifi::minifi::wel
