/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class ResourceLoader {
    private static final ResourceLoader _NULL_RESOURCE_LOADER = new ResourceLoader();
    private final ResourceLoader _parent;

    public static ResourceLoader getNullResourceLoader() {
        return _NULL_RESOURCE_LOADER;
    }

    public URL getResource(String name) throws IOException {
        URL url = this.findResource(name);
        if (url == null && this._parent != null) {
            url = this._parent.getResource(name);
        }
        return url;
    }

    public boolean isCachable() {
        return this._parent == null || this._parent.isCachable();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        if (this._parent != null) {
            result.append("(" + this._parent.toString() + ")");
        }
        return result.toString();
    }

    protected URL findResource(String name) throws IOException {
        return null;
    }

    public static String getContentType(ResourceLoader loader, URLConnection conn) {
        return loader.getContentType(conn);
    }

    protected String getContentType(URLConnection conn) {
        return conn.getContentType();
    }

    protected ResourceLoader getParent() {
        return this._parent;
    }

    protected ResourceLoader(ResourceLoader parent) {
        this._parent = parent;
    }

    protected ResourceLoader() {
        this(null);
    }
}

