/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXComponent;

abstract class ChildLoop
implements ComponentProcessor<Object> {
    private final ComponentProcessingContext _cpContext;

    public ChildLoop() {
        this(null);
    }

    public ChildLoop(ComponentProcessingContext cpContext) {
        this._cpContext = cpContext;
    }

    public final void run(FacesContext context, UIXCollection comp) {
        this.run(context, comp, comp);
    }

    public final void run(FacesContext context, UIXCollection comp, UIComponent child) {
        if (this.shouldRun(comp)) {
            this.runAlways(context, child);
        }
    }

    public final void runAlways(FacesContext context, UIComponent comp) {
        this.runAlways(context, comp.getChildren());
    }

    public final void runAlways(FacesContext context, Collection<UIComponent> kids) {
        try {
            if (this._cpContext != null) {
                UIXComponent.processFlattenedChildren(context, this._cpContext, this, kids, null);
            } else {
                UIXComponent.processFlattenedChildren(context, this, kids, null);
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    @Override
    public void processComponent(FacesContext context, ComponentProcessingContext cpContext, UIComponent component, Object callbackContext) throws IOException {
        this.process(context, component, cpContext);
    }

    protected boolean shouldRun(UIXCollection comp) {
        return comp.isRowAvailable();
    }

    protected final ComponentProcessingContext getComponentProcessingContext() {
        return this._cpContext;
    }

    protected abstract void process(FacesContext var1, UIComponent var2, ComponentProcessingContext var3);

    static final class Decode
    extends ChildLoop {
        Decode() {
        }

        @Override
        protected void process(FacesContext context, UIComponent comp, ComponentProcessingContext cpContext) {
            comp.processDecodes(context);
        }
    }

    static final class Validate
    extends ChildLoop {
        Validate() {
        }

        @Override
        protected void process(FacesContext context, UIComponent comp, ComponentProcessingContext cpContext) {
            comp.processValidators(context);
        }
    }

    static final class Update
    extends ChildLoop {
        Update() {
        }

        @Override
        protected void process(FacesContext context, UIComponent comp, ComponentProcessingContext cpContext) {
            comp.processUpdates(context);
        }
    }
}

