/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageTypeManager;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.util.LRUCache;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

class CacheUtils {
    public static final Color TRANSPARENT_COLOR = new Color(255, 0, 255, 0);
    private static final Map<FontProxy, FontProxy> _sFontProxyCache = Collections.synchronizedMap(new LRUCache(50));
    private static final char[] _BASE_64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-'};

    private CacheUtils() {
    }

    public static int getReadingDirection(ImageContext context, Map<Object, Object> properties) {
        LocaleContext localeContext = context.getLocaleContext();
        int direction = LocaleUtils.getReadingDirection(localeContext);
        if (properties != null) {
            Object o = null;
            o = properties.get(ImageConstants.DIRECTION_KEY);
            if (o != null) {
                direction = (Integer)o;
            }
        }
        if (direction == 0) {
            return LocaleUtils.getReadingDirectionForLocale(localeContext.getTranslationLocale());
        }
        return direction;
    }

    public static boolean getBoolean(Map<Object, Object> properties, Object key, boolean defaultValue) {
        Boolean value = (Boolean)properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void putBoolean(Map<Object, Object> properties, Object key, boolean value) {
        properties.put(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isTextAntialiased(Map<Object, Object> properties) {
        return CacheUtils.getBoolean(properties, ImageConstants.TEXT_ANTIALIAS_KEY, false);
    }

    public static ImageTypeManager getImageTypeManager(ImageContext context) {
        return ImageTypeManager.getDefaultImageTypeManager();
    }

    public static FontProxy getSharedFont(FontProxy font) {
        if (font == null) {
            return null;
        }
        FontProxy sharedFont = _sFontProxyCache.get(font);
        if (sharedFont != null) {
            return sharedFont;
        }
        sharedFont = new FontProxy(font.getName(), font.getStyle(), font.getSize());
        _sFontProxyCache.put(sharedFont, sharedFont);
        return sharedFont;
    }

    public static FontProxy getSharedFont(Map<Object, Object> properties, Object key) {
        return CacheUtils.getSharedFont((FontProxy)properties.get(key));
    }

    public static String base64Encode(int value) {
        StringBuffer buffer = new StringBuffer(6);
        for (int i = 0; i < 4; ++i) {
            buffer.append(_BASE_64_CHARS[value >> 6 * i & 0x3F]);
        }
        return buffer.toString();
    }
}

