/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.webapp.wrappers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicHTMLBrowserRequestWrapper
extends HttpServletRequestWrapper {
    private String encodedParameterName;
    private Map<String, String[]> decodedParamMap;
    private Map<String, String[]> modifiableParameterMap;

    public BasicHTMLBrowserRequestWrapper(HttpServletRequest request) {
        super(request);
        this.initializeDecodedParamterMap();
        this.mergeParameterMap();
    }

    void initializeDecodedParamterMap() {
        String paramName;
        Enumeration enumeration = super.getParameterNames();
        String[] paramDetail = null;
        boolean findSubmit = true;
        while (enumeration.hasMoreElements() && findSubmit) {
            paramName = (String)enumeration.nextElement();
            if (paramName.indexOf("_parameterkey") == -1) continue;
            this.encodedParameterName = paramName;
            paramDetail = paramName.split("_parameterkey");
            findSubmit = false;
        }
        this.decodedParamMap = new HashMap<String, String[]>();
        for (int i = 0; i < paramDetail.length; i += 2) {
            this.decodedParamMap.put((String)paramDetail[i], new String[]{paramDetail[i + 1]});
        }
        if (this.decodedParamMap.containsKey("multipleValueParam")) {
            paramName = this.decodedParamMap.get("multipleValueParam")[0];
            if (!this.decodedParamMap.containsKey("source")) {
                this.decodedParamMap.put("source", new String[]{super.getParameter(paramName)});
            } else {
                this.decodedParamMap.put("value", new String[]{super.getParameter(paramName)});
            }
        }
    }

    void mergeParameterMap() {
        Map originalMap = super.getParameterMap();
        this.modifiableParameterMap = new HashMap<String, String[]>(originalMap);
        this.modifiableParameterMap.remove(this.encodedParameterName);
        this.modifiableParameterMap.putAll(this.decodedParamMap);
    }

    public String[] getParameterValues(String param) {
        return this.modifiableParameterMap.get(param);
    }

    public String getParameter(String param) {
        String[] paramValue = this.getParameterValues(param);
        if (paramValue == null) {
            return null;
        }
        return paramValue[0];
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.modifiableParameterMap);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.modifiableParameterMap.keySet());
    }
}

