/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.schedule.model.Interval;

public class ScheduleUtil {
    private static final String DATE_ID_PATTERN = "yyyyMMdd";

    private ScheduleUtil() {
    }

    public static boolean isBindingExpression(Object value) {
        boolean returnboolean = value != null && value instanceof String && ((String)value).startsWith("#{") && ((String)value).endsWith("}");
        return returnboolean;
    }

    public static boolean getBooleanProperty(UIComponent component, Boolean property, String key, boolean defaultValue) {
        Boolean value;
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Boolean)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(Object attributeValue, boolean valueIfNull) {
        if (attributeValue == null) {
            return valueIfNull;
        }
        if (attributeValue instanceof String) {
            return ((String)attributeValue).equalsIgnoreCase("true");
        }
        return (Boolean)attributeValue;
    }

    public static float getFloatProperty(UIComponent component, Float property, String key, float defaultValue) {
        Float value;
        if (property != null) {
            return property.floatValue();
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Float)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value.floatValue();
        }
        return defaultValue;
    }

    public static int getHashCodeForDay(Date date, TimeZone tz) {
        Calendar calendar = ScheduleUtil.getCalendarInstance(date, tz);
        return new Integer(calendar.get(0)).hashCode() ^ new Integer(calendar.get(1)).hashCode() ^ new Integer(calendar.get(6)).hashCode();
    }

    public static int getIntegerProperty(UIComponent component, Integer property, String key, int defaultValue) {
        Integer value;
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null && (value = (Integer)binding.getValue(FacesContext.getCurrentInstance())) != null) {
            return value;
        }
        return defaultValue;
    }

    public static Object getObjectProperty(UIComponent component, Object property, String key, Object defaultValue) {
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null) {
            return binding.getValue(FacesContext.getCurrentInstance());
        }
        return defaultValue;
    }

    public static boolean isSameDay(Date date1, Date date2, TimeZone tz) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = ScheduleUtil.getCalendarInstance(date1, tz);
        Calendar calendar2 = ScheduleUtil.getCalendarInstance(date2, tz);
        return calendar1.get(0) == calendar2.get(0) && calendar1.get(1) == calendar2.get(1) && calendar1.get(6) == calendar2.get(6);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = ScheduleUtil.getCalendarInstance(date1, null);
        Calendar calendar2 = ScheduleUtil.getCalendarInstance(date2, null);
        return calendar1.get(11) == calendar2.get(11) && calendar1.get(12) == calendar2.get(12) && calendar1.get(13) == calendar2.get(13);
    }

    public static boolean areEquivalentIntervals(TreeSet intervals1, TreeSet intervals2) {
        if (intervals1 == null || intervals2 == null) {
            return intervals1 == null && intervals2 == null;
        }
        if (intervals1.size() == intervals2.size()) {
            Iterator it1 = intervals1.iterator();
            Iterator it2 = intervals2.iterator();
            while (it1.hasNext()) {
                if (((Interval)it1.next()).isEquivalent((Interval)it2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getStringProperty(UIComponent component, String property, String key, String defaultValue) {
        if (property != null) {
            return property;
        }
        ValueBinding binding = component.getValueBinding(key);
        if (binding != null) {
            return (String)binding.getValue(FacesContext.getCurrentInstance());
        }
        return defaultValue;
    }

    public static boolean canModifyValue(UIComponent component) {
        boolean returnboolean = component.isRendered() && !ScheduleUtil.getBooleanValue(component.getAttributes().get("readonly"), false) && !ScheduleUtil.getBooleanValue(component.getAttributes().get("disabled"), false);
        return returnboolean;
    }

    public static int compareDays(Date date1, Date date2, TimeZone tz) {
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return ScheduleUtil.truncate(date1, tz).compareTo(ScheduleUtil.truncate(date2, tz));
    }

    public static Date truncate(Date date, TimeZone tz) {
        if (date == null) {
            return null;
        }
        Calendar cal = ScheduleUtil.getCalendarInstance(date, tz);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getDateId(Date date, TimeZone timeZone) {
        if (date == null) {
            return "NULL";
        }
        return ScheduleUtil.getDateIdFormater(timeZone).format(date);
    }

    public static Date getDateFromId(String id, TimeZone timeZone) {
        if (id == null || id.length() == 0 || "null".equals(id)) {
            return null;
        }
        try {
            return ScheduleUtil.getDateIdFormater(timeZone).parse(id);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Calendar getCalendarInstance(Date date, TimeZone timeZone) {
        Calendar cal = GregorianCalendar.getInstance(timeZone != null ? timeZone : TimeZone.getDefault());
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal;
    }

    private static SimpleDateFormat getDateIdFormater(TimeZone timeZone) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_ID_PATTERN);
        format.setTimeZone(timeZone);
        return format;
    }
}

