/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_4.section_4_2_14;

import java.lang.Boolean;
import java.io.IOException;


import java.util.Map;


import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;



import javax.portlet.Event;
import javax.portlet.StateAwareResponse;


import javax.portlet.RenderRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import javax.xml.namespace.QName;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;

public class Tests
  extends Object
{
  

  // Test is MultiRequest -- Render/Action
  // Test # -- 4.19
  @BridgeTest(test = "isAutoDispatchEventsSetTest")
  public String isAutoDispatchEventsSetTest(TestRunnerBean testRunner)
  { 
    return isAutoDispatchEventsTest(testRunner);
  }
 
  // Test is MultiRequest -- Render/Action
  // Test # -- 4.20
  @BridgeTest(test = "isAutoDispatchEventsNotSetTest")     
  public String isAutoDispatchEventsNotSetTest(TestRunnerBean testRunner)
  { 
    return isAutoDispatchEventsTest(testRunner);
  }
  
  public String isAutoDispatchEventsTest(TestRunnerBean testRunner)
  { 
    FacesContext ctx = FacesContext.getCurrentInstance();
    ExternalContext extCtx = ctx.getExternalContext();
    
    // In the action portion create/attach things to request scope that should either be preserved or
    // are explicitly excluded -- test for presence/absence in render
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      // Create and raise the event -- this ensures isAutoDispatchEvents will get called
      StateAwareResponse response = (StateAwareResponse) extCtx.getResponse();
      response.setEvent(new QName("http://myfaces.apache.org/portlet-bridge/event_ns", "myfaces.apache.org.tck.testEvent"), testRunner.getTestName());
      return "isAutoDispatchEventsTest"; // action Navigation result
    }
    else
    {
      testRunner.setTestComplete(true);
      

      String failedMsg = (String)extCtx.getRequestMap().get("test.fail.");
      String successMsg = (String)extCtx.getRequestMap().get("test.pass.");
     
     if (successMsg != null)
      {
        testRunner.setTestResult(true,
                                 successMsg);
        return Constants.TEST_SUCCESS;
      }
      else if (failedMsg != null)
      {
        testRunner.setTestResult(false,
                                 failedMsg);
        return Constants.TEST_FAILED;
      }
      else
      {
        testRunner.setTestResult(false,
                                 "Unexpected failure: No result string set by the portlet");
        return Constants.TEST_FAILED;
      }
    }
  }
     
}
