/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package javax.portlet.faces;

/**
 * Thrown when the bridge can't resolve the target view from the ViewPath
 * PortletRequest attribute <code>javax.portlet.faces.viewPath</code>.
 */
public class BridgeInvalidViewPathException extends BridgeException
{

  public BridgeInvalidViewPathException()
  {
    super();
  }

  public BridgeInvalidViewPathException(String message)
  {
    super(message);
  }

  public BridgeInvalidViewPathException(String message, Throwable cause)
  {
    super(message, cause);
  }

  public BridgeInvalidViewPathException(Throwable cause)
  {
    super(cause);
  }
}
