/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBox;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends PanelRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIBox box = (AbstractUIBox)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = box.getMarkup();
        writer.startElement(HtmlElements.DIV);
        boolean collapsed = box.isCollapsed();
        writer.writeClassAttribute((CssItem)TobagoClass.BOX, TobagoClass.BOX.createMarkup(markup), new CssItem[]{BootstrapClass.CARD, collapsed ? TobagoClass.COLLAPSED : null, box.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        String clientId = box.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)box);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)box);
        if (box.getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        UIComponent labelFacet = ComponentUtils.getFacet((UIComponent)box, Facets.label);
        String labelString = box.getLabel();
        UIComponent bar = ComponentUtils.getFacet((UIComponent)box, Facets.bar);
        if (labelFacet != null || labelString != null || bar != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.CARD_HEADER, TobagoClass.BOX__HEADER);
            writer.startElement(HtmlElements.H3);
            if (labelFacet != null) {
                for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                    if (child instanceof AbstractUIOut) {
                        child.setRendererType(RendererTypes.OutInsideBoxLabel.name());
                    }
                    child.encodeAll(facesContext);
                }
            } else if (labelString != null) {
                writer.writeText(labelString);
            }
            writer.endElement(HtmlElements.H3);
            if (bar != null) {
                bar.encodeAll(facesContext);
            }
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_BODY);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }
}

