/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.context.DateTimeI18n;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);

    private JsonUtils() {
    }

    private static void encode(StringBuilder builder, String name, String[] value, boolean escape) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        JsonUtils.encode(builder, value, escape);
        builder.append(",");
    }

    public static void encode(StringBuilder builder, String[] value, boolean escape) {
        builder.append("[");
        boolean colon = false;
        for (String item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append("\"");
            if (escape) {
                for (int i = 0; i < item.length(); ++i) {
                    char c = item.charAt(i);
                    if (c == '\"') {
                        builder.append("\\\"");
                        continue;
                    }
                    builder.append(c);
                }
            } else {
                builder.append(item);
            }
            builder.append("\"");
            colon = true;
        }
        builder.append("]");
    }

    public static void encode(StringBuilder builder, List<Integer> value) {
        builder.append("[");
        boolean colon = false;
        for (Integer item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append(item);
            colon = true;
        }
        builder.append("]");
    }

    private static void encode(StringBuilder builder, String name, Boolean value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Boolean.toString(value));
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, Integer value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(Integer.toString(value));
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, String value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":\"");
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            builder.append(c);
        }
        builder.append("\",");
    }

    public static String encode(CommandMap commandMap) {
        Map<ClientBehaviors, Command> other;
        if (commandMap == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        Command click = commandMap.getClick();
        if (click != null) {
            JsonUtils.encode(builder, ClientBehaviors.click, click);
        }
        if ((other = commandMap.getOther()) != null) {
            for (Map.Entry<ClientBehaviors, Command> entry : other.entrySet()) {
                JsonUtils.encode(builder, entry.getKey(), entry.getValue());
            }
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    private static void encode(StringBuilder builder, ClientBehaviors name, Command command) {
        Boolean omit;
        Integer delay;
        String confirmation;
        String focus;
        Collapse collapse;
        String render;
        String execute;
        String target;
        Boolean transition;
        builder.append("\"");
        builder.append((Object)name);
        builder.append("\":{");
        int initialLength = builder.length();
        String action = command.getAction();
        if (action != null) {
            JsonUtils.encode(builder, "action", action);
        }
        if ((transition = command.getTransition()) != null && !transition.booleanValue()) {
            JsonUtils.encode(builder, "transition", transition);
        }
        if ((target = command.getTarget()) != null) {
            JsonUtils.encode(builder, "target", target);
        }
        if ((execute = command.getExecute()) != null) {
            JsonUtils.encode(builder, "execute", execute);
        }
        if ((render = command.getRender()) != null) {
            JsonUtils.encode(builder, "render", render);
        }
        if ((collapse = command.getCollapse()) != null) {
            JsonUtils.encode(builder, "collapse", collapse);
        }
        if ((focus = command.getFocus()) != null) {
            JsonUtils.encode(builder, "focus", focus);
        }
        if ((confirmation = command.getConfirmation()) != null) {
            JsonUtils.encode(builder, "confirmation", confirmation);
        }
        if ((delay = command.getDelay()) != null) {
            JsonUtils.encode(builder, "delay", delay);
        }
        if ((omit = command.getOmit()) != null && omit.booleanValue()) {
            JsonUtils.encode(builder, "omit", (Boolean)true);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    private static void encode(StringBuilder builder, String name, Collapse collapse) {
        String forId;
        builder.append("\"");
        builder.append(name);
        builder.append("\":{");
        int initialLength = builder.length();
        Collapse.Action action = collapse.getAction();
        if (action != null) {
            JsonUtils.encode(builder, "transition", action.name());
        }
        if ((forId = collapse.getFor()) != null) {
            JsonUtils.encode(builder, "forId", forId);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    public static String encode(DateTimeI18n dateTimeI18n) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        JsonUtils.encode(builder, "monthNames", dateTimeI18n.getMonthNames(), false);
        JsonUtils.encode(builder, "monthNamesShort", dateTimeI18n.getMonthNamesShort(), false);
        JsonUtils.encode(builder, "dayNames", dateTimeI18n.getDayNames(), false);
        JsonUtils.encode(builder, "dayNamesShort", dateTimeI18n.getDayNamesShort(), false);
        JsonUtils.encode(builder, "dayNamesMin", dateTimeI18n.getDayNamesMin(), false);
        JsonUtils.encode(builder, "firstDay", dateTimeI18n.getFirstDay());
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String encode(String[] strings, boolean escape) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, strings, escape);
        return builder.toString();
    }

    public static String encode(List<Integer> integers) {
        if (integers == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, integers);
        return builder.toString();
    }

    public static void encode(MeasureList layout, StringBuilder builder) {
        builder.append("[");
        for (Measure measure : layout) {
            Measure.Unit unit = measure.getUnit();
            if (unit == Measure.Unit.FR) {
                float factor = measure.getValue();
                builder.append(factor);
            } else if (unit == Measure.Unit.AUTO) {
                builder.append("\"auto\"");
            } else {
                builder.append("{\"measure\":\"");
                builder.append(measure.serialize());
                builder.append("\"}");
            }
            builder.append(',');
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]");
    }

    public static List<Integer> decodeIntegerArray(String json) {
        String string = json.trim();
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (string.length() < 2 || string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            LOG.warn("Can't parse JSON array: no surrounding square brackets []: '{}'", (Object)string);
        } else {
            string = string.substring(1, string.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(string, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                try {
                    result.add(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Can't parse JSON array: not an integer token: '{}'", (Object)token);
                }
            }
        }
        return result;
    }

    public static String encode(Markup markups) {
        if (markups == null || markups.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(20);
        builder.append('[');
        for (String markup : markups) {
            builder.append('\"');
            builder.append(markup);
            builder.append('\"');
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(']');
        return builder.toString();
    }
}

