/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.RegexValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIButton;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneChoice;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InRenderer
extends MessageLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InRenderer.class);

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIInput input = (AbstractUIInput)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)input);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        boolean password = ComponentUtils.getBooleanAttribute((UIComponent)input, Attributes.password);
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '{}'", (Object)StringUtils.toConfidentialString(currentValue, password));
        }
        HtmlInputTypes type = password ? HtmlInputTypes.PASSWORD : HtmlInputTypes.TEXT;
        String clientId = input.getClientId(facesContext);
        String fieldId = input.getFieldId(facesContext);
        boolean readonly = input.isReadonly();
        boolean disabled = input.isDisabled();
        boolean required = ComponentUtils.getBooleanAttribute((UIComponent)input, Attributes.required);
        Markup markup = input.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet((UIComponent)input, Facets.after);
        UIComponent before = ComponentUtils.getFacet((UIComponent)input, Facets.before);
        if (after != null || before != null) {
            writer.startElement(HtmlElements.DIV);
            if (input.isLabelLayoutSkip()) {
                writer.writeIdAttribute(clientId);
            }
            writer.writeClassAttribute(TobagoClass.INPUT__GROUP__OUTER);
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        }
        this.encodeGroupAddon(facesContext, writer, before, false);
        writer.startElement(HtmlElements.INPUT);
        if (input.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(input.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, input.getAccessKey(), clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, type);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        if (input.isLabelLayoutSkip()) {
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        if (currentValue != null && !password) {
            writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        }
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        int maxLength = 0;
        int minLength = 0;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (validator instanceof LengthValidator) {
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
                minLength = lengthValidator.getMinimum();
                continue;
            }
            if (!(validator instanceof RegexValidator)) continue;
            RegexValidator regexValidator = (RegexValidator)validator;
            pattern = regexValidator.getPattern();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (minLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MINLENGTH, minLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, true);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, input.getTabIndex());
        if (!disabled && !readonly) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, input.getPlaceholder(), true);
        }
        writer.writeClassAttribute((CssItem)this.getRendererCssClass(), this.getRendererCssClass().createMarkup(markup), new CssItem[]{BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity((UIComponent)input)), BootstrapClass.FORM_CONTROL, input.getCustomClass()});
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        HtmlRendererUtils.renderFocus(clientId, input.isFocus(), ComponentUtils.isError(input), facesContext, writer);
        this.writeAdditionalAttributes(facesContext, writer, input);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, input)));
        writer.endElement(HtmlElements.INPUT);
        this.encodeGroupAddon(facesContext, writer, after, true);
        if (after != null || before != null) {
            writer.endElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.DIV);
        }
    }

    private void encodeGroupAddon(FacesContext facesContext, TobagoResponseWriter writer, UIComponent addon, boolean isAfterFacet) throws IOException {
        if (addon != null) {
            for (UIComponent child : RenderUtils.getFacetChildren(addon)) {
                if (child instanceof AbstractUIButton && ((AbstractUIButton)child).isParentOfCommands()) {
                    if (isAfterFacet) {
                        child.setRendererType(RendererTypes.ButtonInsideInAfter.name());
                    } else {
                        child.setRendererType(RendererTypes.ButtonInsideIn.name());
                    }
                    child.encodeAll(facesContext);
                    continue;
                }
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(isAfterFacet ? BootstrapClass.INPUT_GROUP_APPEND : BootstrapClass.INPUT_GROUP_PREPEND);
                if (child instanceof AbstractUIButton) {
                    child.encodeAll(facesContext);
                } else if (child instanceof AbstractUIOut) {
                    child.setRendererType(RendererTypes.OutInsideIn.name());
                    child.encodeAll(facesContext);
                } else if (child instanceof AbstractUISelectOneChoice) {
                    child.setRendererType(RendererTypes.SelectOneChoiceInsideIn.name());
                    child.encodeAll(facesContext);
                } else {
                    writer.startElement(HtmlElements.SPAN);
                    writer.writeClassAttribute(BootstrapClass.INPUT_GROUP_TEXT);
                    child.encodeAll(facesContext);
                    writer.endElement(HtmlElements.SPAN);
                }
                writer.endElement(HtmlElements.DIV);
            }
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected TobagoClass getRendererCssClass() {
        return TobagoClass.IN;
    }

    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIInput input) throws IOException {
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUIInput input = (AbstractUIInput)component;
        return input.getFieldId(facesContext);
    }
}

