/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.lifecycle;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.webapp.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretPhaseListener
implements PhaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(SecretPhaseListener.class);

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (!facesContext.getResponseComplete() && facesContext.isPostback() && TobagoConfig.getInstance(facesContext).isCheckSessionSecret() && !Secret.check(facesContext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Secret is invalid!");
            }
            facesContext.renderResponse();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

