/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeIcon;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIconRenderer
extends LayoutComponentRendererBase {
    protected static final String OPEN_FOLDER = "image/treeNode-icon-open";
    protected static final String CLOSED_FOLDER = "image/treeNode-icon";
    protected static final String LEAF = "image/treeNode-icon-leaf";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String source;
        String openSource;
        int dot;
        UITreeIcon image = (UITreeIcon)component;
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)image, AbstractUIData.class);
        UITreeNode node = (UITreeNode)ComponentUtils.findAncestor((UIComponent)image, UITreeNode.class);
        boolean folder = node.isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        String imageUrl = (String)image.getValue();
        String imageExtension = null;
        if (imageUrl != null && (dot = imageUrl.lastIndexOf(46)) > -1) {
            imageExtension = imageUrl.substring(dot);
            imageUrl = imageUrl.substring(0, dot);
        }
        String closedSource = imageUrl != null ? (imageExtension != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(imageUrl + imageExtension)) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)imageUrl)) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)CLOSED_FOLDER);
        if (folder) {
            openSource = imageUrl != null ? (imageExtension != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(imageUrl + "-open" + imageExtension), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(imageUrl + "-open"), (boolean)true)) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)OPEN_FOLDER);
            source = expanded ? openSource : closedSource;
        } else {
            openSource = null;
            source = imageUrl != null ? (imageExtension != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)(imageUrl + "-leaf" + imageExtension), (boolean)true) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)(imageUrl + "-leaf"), (boolean)true)) : ResourceManagerUtils.getImage((FacesContext)facesContext, (String)LEAF);
        }
        if (source == null) {
            source = closedSource;
        }
        if (source == null) {
            source = openSource;
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle", (Markup)Markup.NULL));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)image);
        writer.writeAttribute("src", source, true);
        if (folder) {
            writer.writeAttribute("data-tobago-src-open", openSource, true);
            writer.writeAttribute("data-tobago-src-close", closedSource, true);
        }
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

