/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation;

/**
 * Methods required to inform the user about some anomalies.
 * <p>
 * These problems can be due either to incorrect webapp development (incorrect use of Orchestra tags)
 * or by something like a session timing out. In any case, when these problems happen they affect the
 * user so need to be reported to the user in some way. However different apps may want to report
 * problems in different ways; the concrete ConversationMessager object used is therefore configurable.
 * <p>
 * All methods on this class must be implemented in a thread-safe manner.
 * <p>
 * The instance used by Orchestra is controlled by the FrameworkAdapter. See 
 * {@link org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter} for details.
 */
public abstract class ConversationMessager
{
    /**
     * An exception happened, for example during invalidate action.
     */
    public void setConversationException(Throwable t)
    {
    }

    /**
     * Display message about a not active conversation (close before the redirect).
     */
    public void setConversationNotActive(String name)
    {
    }
}
