/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib.jsf.ConfigUtils;
import org.apache.myfaces.orchestra.lib.jsf.ContextLockRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.ConversationManagerRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.DataSourceLeakRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.ExternalContextUtils;
import org.apache.myfaces.orchestra.lib.jsf.FrameworkAdapterRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.RequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.RequestType;
import org.apache.myfaces.orchestra.lib.jsf._PortletFacesContextWrapper;
import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterServletFilter;

public class PortletOrchestraFacesContextFactory {
    private final Log log = LogFactory.getLog(PortletOrchestraFacesContextFactory.class);
    private final AtomicLong _count = new AtomicLong(1L);
    private static final String REQUEST_CONTEXT_PARAM = "requestContext";
    private static final String CONVERSATION_CONTEXT_PARAM = "conversationContext";
    public static final String REQUEST_HANDLERS = "org.apache.myfaces.orchestra.REQUEST_HANDLERS";
    public static final String PORTLET_LIFECYCLE_PHASE = "javax.portlet.orchestra.phase";

    protected String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Integer.toString(this.hashCode()) + nextToken;
    }

    public FacesContext getFacesContext(FacesContext facesContext, Object context, Object request, Object response) throws FacesException {
        ExternalContext externalContext = facesContext.getExternalContext();
        List<DataSourceLeakRequestHandler> handlers = null;
        boolean init = false;
        String nextToken = null;
        Map requestMap = externalContext.getRequestMap();
        RequestType type = ExternalContextUtils.getRequestType(context, request);
        if (RequestType.RENDER.equals(type)) {
            PortletRequest portletRequest = (PortletRequest)request;
            nextToken = portletRequest.getParameter(CONVERSATION_CONTEXT_PARAM);
            if (nextToken == null) {
                nextToken = portletRequest.getParameter(REQUEST_CONTEXT_PARAM);
            }
            if (nextToken != null) {
                handlers = (List)externalContext.getApplicationMap().remove(REQUEST_HANDLERS + nextToken);
            }
        }
        if (RequestType.RENDER.equals(type)) {
            requestMap.put(PORTLET_LIFECYCLE_PHASE, "RENDER_PHASE");
        } else if (RequestType.ACTION.equals(type)) {
            requestMap.put(PORTLET_LIFECYCLE_PHASE, "ACTION_PHASE");
        } else if (RequestType.EVENT.equals(type)) {
            requestMap.put(PORTLET_LIFECYCLE_PHASE, "EVENT_PHASE");
        } else if (RequestType.RESOURCE.equals(type)) {
            requestMap.put(PORTLET_LIFECYCLE_PHASE, "RESOURCE_PHASE");
        }
        if (handlers == null) {
            handlers = new LinkedList<RequestHandler>();
            handlers.add((DataSourceLeakRequestHandler)((Object)new FrameworkAdapterRequestHandler()));
            handlers.add((DataSourceLeakRequestHandler)((Object)new ConversationManagerRequestHandler()));
            handlers.add(new DataSourceLeakRequestHandler());
            Map reqScope = facesContext.getExternalContext().getRequestMap();
            handlers.addAll(ConfigUtils.getRequestHandlers(reqScope));
            if (RequestType.ACTION.equals(ExternalContextUtils.getRequestType(context, request))) {
                ActionResponse actionResponse = (ActionResponse)response;
                PortletRequest portletRequest = (PortletRequest)request;
                nextToken = portletRequest.getParameter(CONVERSATION_CONTEXT_PARAM);
                if (nextToken == null) {
                    nextToken = this._getNextToken();
                    actionResponse.setRenderParameter(REQUEST_CONTEXT_PARAM, nextToken);
                }
                if (nextToken != null) {
                    externalContext.getApplicationMap().put(REQUEST_HANDLERS + nextToken, handlers);
                }
            }
            init = true;
        }
        this.setRequestParameterResponseWrappedMode(context, request);
        ContextLockRequestHandler contextLockHandler = new ContextLockRequestHandler();
        return new _PortletFacesContextWrapper(facesContext, true, init, nextToken, handlers, contextLockHandler);
    }

    private void setRequestParameterResponseWrappedMode(Object context, Object request) {
        FrameworkAdapter nonJsfFrameworkAdapter = FrameworkAdapter.getCurrentInstance();
        if (nonJsfFrameworkAdapter != null) {
            if (!Boolean.TRUE.equals(nonJsfFrameworkAdapter.getRequestAttribute(RequestParameterServletFilter.REQUEST_PARAM_FILTER_CALLED))) {
                nonJsfFrameworkAdapter.setRequestAttribute(RequestParameterServletFilter.REQUEST_PARAM_RESPONSE_WRAPPED, Boolean.TRUE);
            }
        } else if (!this.getBooleanRequestValue(request, RequestParameterServletFilter.REQUEST_PARAM_FILTER_CALLED)) {
            this.setBooleanRequestValue(request, RequestParameterServletFilter.REQUEST_PARAM_RESPONSE_WRAPPED, Boolean.TRUE);
        }
    }

    private boolean getBooleanRequestValue(Object request, String key) {
        PortletRequest portletRequest = (PortletRequest)request;
        return Boolean.TRUE.equals(portletRequest.getAttribute(key));
    }

    private void setBooleanRequestValue(Object request, String key, Boolean value) {
        PortletRequest portletRequest = (PortletRequest)request;
        portletRequest.setAttribute(key, (Object)value);
    }
}

