/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.spring;

import org.apache.myfaces.orchestra.conversation.ConversationBindingEvent;
import org.apache.myfaces.orchestra.conversation.ConversationBindingListener;

/**
 * A simple class to tidy up persistence contexts.
 * <p>
 * An instance of this class can be stored into the attributes of a specific
 * Conversation object. Because it implements ConversationBindingListener, it
 * receives a valueUnbound callback when the Conversation is terminated. It
 * then closes the persistence context object associated with the Conversation. 
 */
public class PersistenceContextCloser implements ConversationBindingListener
{
    private final PersistenceContext persistenceContext;

    public PersistenceContextCloser(PersistenceContext persistenceContext)
    {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext()
    {
        return persistenceContext;
    }

    public void valueBound(ConversationBindingEvent event)
    {
    }

    public void valueUnbound(ConversationBindingEvent event)
    {
        persistenceContext.close();
    }
}
