/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.DefaultExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValModuleConfiguration;
import org.apache.myfaces.extensions.validator.core.ProjectStageResolver;
import org.apache.myfaces.extensions.validator.core.proxy.ProxyHelper;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererProxy;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ValidationParameter;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public abstract class ExtValCoreConfiguration
implements ExtValModuleConfiguration {
    private static ExtValContext extValContext = null;
    private static final Logger LOGGER = Logger.getLogger(ExtValCoreConfiguration.class.getName());
    private static final String MISSING_MODULE_CONFIG_MESSAGE = "no config for " + ExtValCoreConfiguration.class.getName() + " found. " + "maybe the call of ExtValCoreConfig#get is triggered before the registration process." + "the default config gets used.";

    protected ExtValCoreConfiguration() {
    }

    private static ExtValContext getExtValContext() {
        if (extValContext == null) {
            extValContext = ExtValContext.getContext();
        }
        return extValContext;
    }

    public static ExtValCoreConfiguration get() {
        ExtValCoreConfiguration moduleConfig = ExtValCoreConfiguration.getExtValContext().getModuleConfiguration(ExtValCoreConfiguration.class);
        if (moduleConfig == null) {
            LOGGER.fine(MISSING_MODULE_CONFIG_MESSAGE);
        }
        return moduleConfig != null ? moduleConfig : new DefaultExtValCoreConfiguration();
    }

    @UsageInformation(value={UsageCategory.INTERNAL})
    public static boolean use(ExtValCoreConfiguration config, boolean forceOverride) {
        return ExtValCoreConfiguration.getExtValContext().addModuleConfiguration(ExtValCoreConfiguration.class, config, forceOverride);
    }

    public abstract String customMessageBundleBaseName();

    public abstract String customBasePackage();

    public abstract String customInformationProviderBeanClassName();

    public abstract String customComponentMetaDataExtractorClassName();

    public abstract String customValidationParameterExtractorClassName();

    public abstract String customStaticValidationStrategyMappingSource();

    public abstract String customComponentInitializerClassName();

    public abstract String customValidationExceptionInterceptorClassName();

    public abstract String customPropertyValidationInterceptorClassName();

    public abstract String customMetaDataExtractionInterceptorClassName();

    public abstract ProxyHelper proxyHelper();

    public abstract ProjectStageResolver projectStageResolver();

    public abstract Class<? extends ExtValRendererProxy> rendererProxy();

    public abstract Class<? extends Annotation> constraintSourceAnnotation();

    public abstract Class<? extends Annotation> ignoreConstraintSourceAnnotation();

    public abstract Class<? extends Annotation> targetPropertyAnnotation();

    public abstract Class<? extends Annotation> targetPropertyIdAnnotation();

    public abstract Class violationSeverity();

    public abstract Class<? extends ValidationParameter> disableClientSideValidationValidationParameter();

    public abstract String customValidationStrategyToMessageResolverNameMapperClassName();

    public abstract String customMetaDataToValidationStrategyNameMapperClassName();

    public abstract String customValidationStrategyToMetaDataTransformerNameMapperClassName();

    public abstract String customMetaDataStorageFilterClassName();

    public abstract String customValidationStrategyFactoryClassName();

    public abstract String customMessageResolverFactoryClassName();

    public abstract String customComponentMetaDataExtractorFactoryClassName();

    public abstract String customValidationParameterExtractorFactoryClassName();

    public abstract String customValidationParameterFactoryClassName();

    public abstract String customMetaDataTransformerFactoryClassName();

    public abstract String customStorageManagerFactoryClassName();

    public abstract String customFacesMessageFactoryClassName();

    public abstract boolean activateRequiredInitialization();

    public abstract boolean deactivateDefaultConvention();

    public abstract boolean deactivateDefaultNameMappers();

    @Deprecated
    public abstract boolean deactivateElResolver();

    public abstract boolean deactivateComponentInitialization();

    public abstract boolean deactivateValidationParameters();

    public abstract boolean deactivateRenderKitFactory();

    public abstract boolean deactivateRequiredAttributeSupport();

    public abstract boolean interpretEmptyStringSubmittedValuesAsNull();

    public abstract boolean validateEmptyFields();

    public abstract boolean activateMarkupMetaData();
}

