/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.config.ClientConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.request.RequestTypeResolver;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultWindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.LifecycleAwareWindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;

@Alternative
@ApplicationScoped
public class ClientSideWindowHandler
extends DefaultWindowHandler
implements LifecycleAwareWindowHandler {
    private static final long serialVersionUID = 5293942986187078113L;
    private static final String WINDOW_ID_COOKIE_PREFIX = "codiWindowId-";
    private static final String CODI_REQUEST_TOKEN = "mfRid";
    private static final String UNINITIALIZED_WINDOW_ID_VALUE = "uninitializedWindowId";
    private static final String WINDOW_ID_REPLACE_PATTERN = "$$windowIdValue$$";
    private static final String NOSCRIPT_URL_REPLACE_PATTERN = "$$noscriptUrl$$";
    private static final String NOSCRIPT_PARAMETER = "mfDirect";
    @Inject
    private ClientConfig clientConfig;
    @Inject
    private EditableWindowContextManager windowContextManager;
    @Inject
    private RequestTypeResolver requestTypeResolver;
    @Inject
    private WindowContextConfig windowContextConfig;

    protected ClientSideWindowHandler() {
    }

    @Inject
    protected ClientSideWindowHandler(WindowContextConfig config) {
        super(config);
    }

    public String restoreWindowId(ExternalContext externalContext) {
        if (this.clientConfig.isJavaScriptEnabled()) {
            return (String)externalContext.getRequestMap().get("windowId");
        }
        return super.restoreWindowId(externalContext);
    }

    public void beforeLifecycleExecute(FacesContext facesContext) {
        if (!this.isClientSideWindowHandlerRequest(facesContext)) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (this.isNoscriptRequest(externalContext)) {
            this.clientConfig.setJavaScriptEnabled(false);
            return;
        }
        String windowId = this.getWindowIdFromCookie(externalContext);
        if (windowId == null) {
            this.sendWindowHandlerHtml(externalContext, null);
            facesContext.responseComplete();
        } else if ("automatedEntryPoint".equals(windowId) || !this.windowContextConfig.isUnknownWindowIdsAllowed() && !ConversationUtils.isWindowActive(this.windowContextManager, windowId)) {
            windowId = this.windowContextManager.getCurrentWindowContext().getId();
            this.sendWindowHandlerHtml(externalContext, windowId);
            facesContext.responseComplete();
        } else {
            externalContext.getRequestMap().put("windowId", windowId);
        }
    }

    private boolean isClientSideWindowHandlerRequest(FacesContext facesContext) {
        return !this.requestTypeResolver.isPostRequest() && this.clientConfig.isClientSideWindowHandlerRequest(facesContext);
    }

    private boolean isNoscriptRequest(ExternalContext externalContext) {
        String noscript = (String)externalContext.getRequestParameterMap().get(NOSCRIPT_PARAMETER);
        return noscript != null && "true".equals(noscript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWindowHandlerHtml(ExternalContext externalContext, String windowId) {
        HttpServletResponse httpResponse = (HttpServletResponse)externalContext.getResponse();
        try {
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/html");
            String windowHandlerHtml = this.clientConfig.getWindowHandlerHtml();
            if (windowId == null) {
                windowId = UNINITIALIZED_WINDOW_ID_VALUE;
            }
            windowHandlerHtml = windowHandlerHtml.replace(WINDOW_ID_REPLACE_PATTERN, windowId);
            windowHandlerHtml = windowHandlerHtml.replace(NOSCRIPT_URL_REPLACE_PATTERN, this.getNoscriptUrl(externalContext));
            ServletOutputStream os = httpResponse.getOutputStream();
            try {
                os.write(windowHandlerHtml.getBytes());
            }
            finally {
                os.close();
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    private String getNoscriptUrl(ExternalContext externalContext) {
        int lastSlash;
        String url = externalContext.getRequestPathInfo();
        if (url == null) {
            url = "";
        }
        if ((lastSlash = url.lastIndexOf(47)) != -1) {
            url = url.substring(lastSlash + 1);
        }
        url = (url = JsfUtils.addParameters(externalContext, url, true, true, true)).contains("?") ? url + "&" : url + "?";
        url = url + NOSCRIPT_PARAMETER + "=true";
        url = url.replace("\"", "");
        url = url.replace("'", "");
        return url;
    }

    private String getWindowIdFromCookie(ExternalContext externalContext) {
        String cookieName = WINDOW_ID_COOKIE_PREFIX + this.getRequestToken(externalContext);
        Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            return cookie.getValue();
        }
        return null;
    }

    private String getRequestToken(ExternalContext externalContext) {
        String requestToken = (String)externalContext.getRequestParameterMap().get(CODI_REQUEST_TOKEN);
        if (requestToken != null) {
            return requestToken;
        }
        return "";
    }
}

