/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.faces.context.FacesContext;
import javax.interceptor.InvocationContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.View;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.AfterPhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase.spi.ViewControllerStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Dependent
public class DefaultViewControllerStrategy
implements ViewControllerStrategy {
    private static final long serialVersionUID = -4380864019324445036L;

    public Object execute(InvocationContext invocationContext) throws Exception {
        Object result = null;
        if (this.invokeListenerMethod(invocationContext)) {
            result = invocationContext.proceed();
        }
        return result;
    }

    private boolean invokeListenerMethod(InvocationContext invocationContext) {
        if (!this.isObserverMethod(invocationContext)) {
            return true;
        }
        View view = this.getViewAnnotation(invocationContext);
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        if (view.inline().length > 1 || !"".equals(view.inline()[0])) {
            return this.isMethodBoundToView(view.inline(), viewId);
        }
        return this.isMethodBoundToViewDefinition(view.value(), viewId);
    }

    private boolean isObserverMethod(InvocationContext invocationContext) {
        Annotation[][] arr$ = invocationContext.getMethod().getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                if (!BeforePhase.class.isAssignableFrom(annotation.annotationType()) && !AfterPhase.class.isAssignableFrom(annotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    private View getViewAnnotation(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod();
        View view = method.isAnnotationPresent(View.class) ? method.getAnnotation(View.class) : method.getDeclaringClass().getAnnotation(View.class);
        return view;
    }

    private boolean isMethodBoundToView(String[] viewIds, String viewId) {
        for (String current : viewIds) {
            if (!current.equals(viewId)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodBoundToViewDefinition(Class<? extends ViewConfig>[] viewDefinitions, String viewId) {
        for (Class<? extends ViewConfig> viewDefinition : viewDefinitions) {
            if (!this.resolveViewId(viewDefinition).equals(viewId)) continue;
            return true;
        }
        return false;
    }

    private String resolveViewId(Class<? extends ViewConfig> viewDefinitionClass) {
        return ViewConfigCache.getViewConfigDescriptor(viewDefinitionClass).getViewId();
    }
}

