/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.flash;

import jakarta.faces.FacesWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import java.io.Serializable;
import org.apache.myfaces.context.flash.ReleasableFlash;
import org.apache.myfaces.util.lang.LRULinkedHashMap;

class FlashClientWindowTokenCollection
implements Serializable {
    private LRULinkedHashMap<String, String> map;

    public FlashClientWindowTokenCollection(int capacity) {
        this.map = new LRULinkedHashMap(capacity, eldest -> {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Flash flash = facesContext.getExternalContext().getFlash();
            if (flash != null) {
                ReleasableFlash rf = null;
                while (flash != null) {
                    if (flash instanceof ReleasableFlash) {
                        rf = (ReleasableFlash)flash;
                        break;
                    }
                    if (flash instanceof FacesWrapper) {
                        flash = (Flash)((FacesWrapper)flash).getWrapped();
                        continue;
                    }
                    flash = null;
                }
                if (rf != null) {
                    rf.clearFlashMap(facesContext, (String)eldest.getKey(), (String)eldest.getValue());
                }
            }
        });
    }

    public FlashClientWindowTokenCollection() {
    }

    public synchronized void put(String key, String value) {
        this.map.put(key, value);
    }

    public synchronized String get(String key) {
        return (String)this.map.get(key);
    }

    public synchronized void remove(String key) {
        this.map.remove(key);
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }
}

