/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.impl.DefaultFacesFlowProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesFlowProviderFactory {
    private static final String FACTORY_KEY = FacesFlowProviderFactory.class.getName();

    public static FacesFlowProviderFactory getFacesFlowProviderFactory(ExternalContext ctx) {
        FacesFlowProviderFactory factory = (FacesFlowProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                factory = (FacesFlowProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, FacesFlowProviderFactory.class, DefaultFacesFlowProviderFactory.class));
            } else {
                factory = (FacesFlowProviderFactory)SpiUtils.build(ctx, FacesFlowProviderFactory.class, DefaultFacesFlowProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            FacesFlowProviderFactory.setFacesFlowProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setFacesFlowProviderFactory(ExternalContext ctx, FacesFlowProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract FacesFlowProvider getFacesFlowProvider(ExternalContext var1);
}

