/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.PassthroughRule;
import org.apache.myfaces.view.facelets.tag.BeanPropertyTagRule;
import org.apache.myfaces.view.facelets.tag.LambdaMetadataTargetImpl;
import org.apache.myfaces.view.facelets.tag.MetadataImpl;
import org.apache.myfaces.view.facelets.tag.MetadataTargetImpl;
import org.apache.myfaces.view.facelets.tag.NullMetadata;

public final class MetaRulesetImpl
extends MetaRuleset {
    private static final Logger log = Logger.getLogger(MetaRulesetImpl.class.getName());
    private static volatile WeakHashMap<ClassLoader, Map<String, MetadataTarget>> metadata = new WeakHashMap();
    private static final TagAttribute[] EMPTY = new TagAttribute[0];
    private final Map<String, TagAttribute> _attributes;
    private final TagAttribute[] _passthroughAttributes;
    private final List<Metadata> _mappers;
    private final List<MetaRule> _rules;
    private final Tag _tag;
    private final Class<?> _type;
    private final List<MetaRule> _passthroughRules;

    public static void clearMetadataTargetCache() {
        metadata.remove(ClassUtils.getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, MetadataTarget> getMetaData() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        Map metadata = MetaRulesetImpl.metadata.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, Map<String, MetadataTarget>> weakHashMap = MetaRulesetImpl.metadata;
            synchronized (weakHashMap) {
                metadata = MetaRulesetImpl.metadata.computeIfAbsent(cl, k -> new HashMap());
            }
        }
        return metadata;
    }

    public MetaRulesetImpl(Tag tag, Class<?> type) {
        this._tag = tag;
        this._type = type;
        TagAttribute[] allAttributes = this._tag.getAttributes().getAll();
        int initialSize = allAttributes.length > 0 ? (allAttributes.length * 4 + 3) / 3 : 4;
        this._attributes = new HashMap<String, TagAttribute>(initialSize);
        this._mappers = new ArrayList<Metadata>(initialSize);
        this._rules = new ArrayList<MetaRule>(8);
        this._passthroughRules = new ArrayList<MetaRule>(2);
        TagAttribute[] passthroughAttribute = this._tag.getAttributes().getAll("jakarta.faces.passthrough");
        TagAttribute[] passthroughAttributeJcp = this._tag.getAttributes().getAll("http://xmlns.jcp.org/jsf/passthrough");
        TagAttribute[] passthroughAttributeSun = this._tag.getAttributes().getAll("http://java.sun.com/jsf/passthrough");
        if (passthroughAttribute.length > 0 || passthroughAttributeJcp.length > 0 || passthroughAttributeSun.length > 0) {
            this._passthroughAttributes = new TagAttribute[passthroughAttribute.length + passthroughAttributeJcp.length + passthroughAttributeSun.length];
            int i = 0;
            for (TagAttribute attribute : allAttributes) {
                if (attribute.getNamespace().length() > 0 && ("jakarta.faces.passthrough".equals(attribute.getNamespace()) || "http://xmlns.jcp.org/jsf/passthrough".equals(attribute.getNamespace()) || "http://java.sun.com/jsf/passthrough".equals(attribute.getNamespace()))) {
                    this._passthroughAttributes[i] = attribute;
                    ++i;
                    continue;
                }
                this._attributes.put(attribute.getLocalName(), attribute);
            }
        } else {
            this._passthroughAttributes = EMPTY;
            for (TagAttribute attribute : allAttributes) {
                this._attributes.put(attribute.getLocalName(), attribute);
            }
        }
        this._rules.add(BeanPropertyTagRule.INSTANCE);
    }

    @Override
    public MetaRuleset add(Metadata mapper) {
        Assert.notNull(mapper, "mapper");
        if (!this._mappers.contains(mapper)) {
            this._mappers.add(mapper);
        }
        return this;
    }

    @Override
    public MetaRuleset addRule(MetaRule rule) {
        Assert.notNull(rule, "rule");
        if (rule instanceof PassthroughRule) {
            this._passthroughRules.add(rule);
        } else {
            this._rules.add(rule);
        }
        return this;
    }

    @Override
    public MetaRuleset alias(String attribute, String property) {
        Assert.notNull(attribute, "attribute");
        Assert.notNull(property, "property");
        TagAttribute attr = this._attributes.remove(attribute);
        if (attr != null) {
            this._attributes.put(property, attr);
        }
        return this;
    }

    @Override
    public Metadata finish() {
        int ruleEnd;
        MetadataTarget target = null;
        assert (!this._rules.isEmpty());
        if (!this._attributes.isEmpty()) {
            target = this._getMetadataTarget();
            ruleEnd = this._rules.size() - 1;
            for (Map.Entry<String, TagAttribute> entry : this._attributes.entrySet()) {
                MetaRule rule;
                Metadata data = null;
                int i = ruleEnd;
                while ((data = (rule = this._rules.get(i)).applyRule(entry.getKey(), entry.getValue(), target)) == null && --i >= 0) {
                }
                if (data == null) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this._type.getName());
                    continue;
                }
                this._mappers.add(data);
            }
        }
        if (this._passthroughAttributes.length > 0 && this._passthroughRules.size() > 0) {
            if (target == null) {
                target = this._getMetadataTarget();
            }
            ruleEnd = this._passthroughRules.size() - 1;
            for (TagAttribute passthroughAttribute : this._passthroughAttributes) {
                MetaRule rule;
                Metadata data = null;
                int i = ruleEnd;
                while ((data = (rule = this._passthroughRules.get(i)).applyRule(passthroughAttribute.getLocalName(), passthroughAttribute, target)) == null && --i >= 0) {
                }
                if (data == null) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.severe(passthroughAttribute.getLocalName() + " Unhandled by MetaTagHandler for type " + this._type.getName());
                    continue;
                }
                this._mappers.add(data);
            }
        }
        if (this._mappers.isEmpty()) {
            return NullMetadata.INSTANCE;
        }
        return new MetadataImpl(this._mappers.toArray(new Metadata[this._mappers.size()]));
    }

    @Override
    public MetaRuleset ignore(String attribute) {
        Assert.notNull(attribute, "attribute");
        this._attributes.remove(attribute);
        return this;
    }

    @Override
    public MetaRuleset ignoreAll() {
        this._attributes.clear();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataTarget _getMetadataTarget() {
        String metaKey;
        Map<String, MetadataTarget> metadata = MetaRulesetImpl.getMetaData();
        MetadataTarget meta = metadata.get(metaKey = this._type.getName());
        if (meta == null) {
            try {
                meta = PropertyDescriptorUtils.isUseLambdaMetafactory(FacesContext.getCurrentInstance().getExternalContext()) ? new LambdaMetadataTargetImpl(this._type) : new MetadataTargetImpl(this._type);
            }
            catch (IntrospectionException e) {
                throw new TagException(this._tag, "Error Creating TargetMetadata", e);
            }
            Map<String, MetadataTarget> map = metadata;
            synchronized (map) {
                metadata.put(metaKey, meta);
            }
        }
        return meta;
    }
}

