/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.context.ExternalContext;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.config.webparameters.MyfacesConfig;

public final class JavascriptUtils {
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "in", "instanceof", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with"));

    private JavascriptUtils() {
    }

    public static String getValidJavascriptNameAsInRI(String origIdentifier) {
        return origIdentifier.replaceAll("-", "\\$_");
    }

    public static String getValidJavascriptName(String s, boolean checkForReservedWord) {
        if (checkForReservedWord && RESERVED_WORDS.contains(s)) {
            return s + "_";
        }
        StringBuilder buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            byte[] bytes = Character.toString(c).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static String encodeString(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    app = "\\\\";
                    break;
                }
                case '\"': {
                    app = "\\\"";
                    break;
                }
                case '\'': {
                    app = "\\'";
                    break;
                }
                case '\n': {
                    app = "\\n";
                    break;
                }
                case '\r': {
                    app = "\\r";
                    break;
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean isRenderClearJavascriptOnButton(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        return myfacesConfig.isRenderClearJavascriptOnButton();
    }
}

