/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.application.FacesServletMapping;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.util.ExternalContextUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.webapp.DelegatedFacesServlet;

public class FacesServletMappingUtils {
    private static final String FACES_SERVLET_REGISTRATION = "org.apache.myfaces.FACES_SERVLET_REGISTRATION";
    private static final String SERVLET_REGISTRATIONS = "org.apache.myfaces.SERVLET_REGISTRATIONS";
    private static final String CURRENT_REQUEST_FACES_SERVLET = "org.apache.myfaces.CURRENT_FACES_SERVLET_MAPPING";

    public static FacesServletMapping getCurrentRequestFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CURRENT_REQUEST_FACES_SERVLET);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = FacesServletMappingUtils.calculateFacesServletMapping(context, externalContext.getRequestServletPath(), externalContext.getRequestPathInfo(), true);
            attributes.put(CURRENT_REQUEST_FACES_SERVLET, mapping);
        }
        return mapping;
    }

    public static List<ServletRegistrationInfo> getServletRegistrations(FacesContext facesContext, ServletContext servletContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        List<ServletRegistrationInfo> infos = (ArrayList)applicationMap.get(SERVLET_REGISTRATIONS);
        if (infos == null) {
            infos = new ArrayList();
            Map registrations = servletContext.getServletRegistrations();
            if (registrations != null) {
                for (ServletRegistration servletRegistration : registrations.values()) {
                    ServletRegistrationInfo info = new ServletRegistrationInfo(servletRegistration, FacesServletMappingUtils.isFacesServlet(facesContext, servletRegistration.getClassName()));
                    infos.add(info);
                }
            }
            infos = Collections.unmodifiableList(infos);
            if (!(facesContext instanceof StartupFacesContextImpl)) {
                applicationMap.put(SERVLET_REGISTRATIONS, infos);
            }
        }
        return infos;
    }

    public static ServletRegistrationInfo getFacesServletRegistration(FacesContext facesContext, ServletContext servletContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        ServletRegistrationInfo facesServletRegistration = (ServletRegistrationInfo)applicationMap.get(FACES_SERVLET_REGISTRATION);
        if (facesServletRegistration == null) {
            for (ServletRegistrationInfo info : FacesServletMappingUtils.getServletRegistrations(facesContext, servletContext)) {
                if (!info.isFacesServlet()) continue;
                facesServletRegistration = info;
                break;
            }
            if (facesServletRegistration != null && !(facesContext instanceof StartupFacesContextImpl)) {
                applicationMap.put(FACES_SERVLET_REGISTRATION, facesServletRegistration);
            }
        }
        return facesServletRegistration;
    }

    public static boolean isFacesServlet(FacesContext facesContext, String servletClassName) {
        if (FacesServlet.class.getName().equals(servletClassName)) {
            return true;
        }
        Class servletClass = ClassUtils.simpleClassForName(servletClassName, false);
        if (servletClass != null) {
            MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext);
            return FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(config.getDelegateFacesServlet());
        }
        return false;
    }

    public static FacesServletMapping calculateFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo, boolean allowExactMapping) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, allowExactMapping);
            }
            String extension = FacesServletMappingUtils.extractExtensionFromUrl(servletPath);
            if (extension != null) {
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, allowExactMapping);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    private static FacesServletMapping createMappingFromServletRegistration(FacesContext facesContext, ServletContext servletContext, String servletPath, String pathInfo, boolean allowExactMatch) {
        try {
            List<ServletRegistrationInfo> servletRegistrations = FacesServletMappingUtils.getServletRegistrations(facesContext, servletContext);
            if (servletRegistrations != null) {
                FacesServletMapping facesExtensionMapping = null;
                FacesServletMapping facesPrefixMapping = null;
                FacesServletMapping facesExactMapping = null;
                for (ServletRegistrationInfo servletRegistration : servletRegistrations) {
                    try {
                        if (servletRegistration.isFacesServlet()) {
                            for (String mapping : servletRegistration.getMappings()) {
                                if (FacesServletMappingUtils.isExtensionMapping(mapping)) {
                                    facesExtensionMapping = FacesServletMapping.createExtensionMapping(FacesServletMappingUtils.extractExtension(mapping));
                                    continue;
                                }
                                if (FacesServletMappingUtils.isPrefixMapping(mapping)) {
                                    facesPrefixMapping = FacesServletMapping.createPrefixMapping(FacesServletMappingUtils.extractPrefix(mapping));
                                    continue;
                                }
                                if (!allowExactMatch || !mapping.startsWith("/") || !mapping.equals(servletPath)) continue;
                                facesExactMapping = FacesServletMapping.createExactMapping(servletPath);
                            }
                            continue;
                        }
                        for (String mapping : servletRegistration.getMappings()) {
                            if (mapping.startsWith("/") && mapping.endsWith("/*")) {
                                mapping = mapping.substring(0, mapping.length() - 2);
                            }
                            if (!mapping.equals(servletPath)) continue;
                            return FacesServletMapping.createPrefixMapping(mapping);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                if (allowExactMatch && facesExactMapping != null) {
                    return facesExactMapping;
                }
                if (facesPrefixMapping != null) {
                    return facesPrefixMapping;
                }
                if (facesExtensionMapping != null) {
                    return facesExtensionMapping;
                }
                return FacesServletMapping.createPrefixMapping(servletPath);
            }
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        catch (Exception ex) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
    }

    private static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        String extension = FacesServletMappingUtils.extractExtensionFromUrl(servletPath);
        if (extension != null) {
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createExactMapping(servletPath);
    }

    public static FacesServletMapping getExactMapping(FacesContext facesContext, String prefixedExactMappingViewId) {
        ServletRegistrationInfo facesServletRegistration;
        Object context;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext && (facesServletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, (ServletContext)context)) != null) {
            for (String mapping : facesServletRegistration.getMappings()) {
                if (mapping.contains("*") || !prefixedExactMappingViewId.equals(mapping)) continue;
                return FacesServletMapping.createExactMapping(prefixedExactMappingViewId);
            }
        }
        return null;
    }

    public static FacesServletMapping getGenericPrefixOrSuffixMapping(FacesContext facesContext) {
        ServletRegistrationInfo facesServletRegistration;
        Object context;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext && (facesServletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, (ServletContext)context)) != null) {
            for (String mapping : facesServletRegistration.getMappings()) {
                if (FacesServletMappingUtils.isExtensionMapping(mapping)) {
                    String extension = FacesServletMappingUtils.extractExtension(mapping);
                    return FacesServletMapping.createExtensionMapping(extension);
                }
                if (!FacesServletMappingUtils.isPrefixMapping(mapping)) continue;
                String prefix = FacesServletMappingUtils.extractPrefix(mapping);
                return FacesServletMapping.createPrefixMapping(prefix);
            }
        }
        return null;
    }

    private static String extractExtensionFromUrl(String url) {
        int slashPos = url.lastIndexOf(47);
        int extensionPos = url.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            return url.substring(extensionPos);
        }
        return null;
    }

    private static boolean isExtensionMapping(String mapping) {
        return mapping.startsWith("*.");
    }

    private static String extractExtension(String mapping) {
        return mapping.substring(1);
    }

    private static boolean isPrefixMapping(String mapping) {
        return mapping.startsWith("/") && mapping.endsWith("/*");
    }

    private static String extractPrefix(String mapping) {
        return mapping.substring(0, mapping.length() - 2);
    }

    public static class ServletRegistrationInfo {
        private String className;
        private String[] mappings;
        private boolean facesServlet;
        private ServletRegistration registration;

        public ServletRegistrationInfo(ServletRegistration registration, boolean facesServlet) {
            this.className = registration.getClassName();
            this.facesServlet = facesServlet;
            this.registration = registration;
            Collection mappingsCollection = registration.getMappings();
            this.mappings = mappingsCollection.toArray(new String[mappingsCollection.size()]);
            if (this.mappings == null) {
                this.mappings = new String[0];
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String[] getMappings() {
            return this.mappings;
        }

        public boolean isFacesServlet() {
            return this.facesServlet;
        }

        public ServletRegistration getRegistration() {
            return this.registration;
        }
    }
}

