/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.faces.event.WebsocketEvent;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.apache.myfaces.push.WebsocketSessionClusterSerializedRestore;
import org.apache.myfaces.push.cdi.WebsocketApplicationSessionHolder;

public class EndpointImpl
extends Endpoint {
    public static final String JAKARTA_FACES_PUSH_PATH = "/jakarta.faces.push/{channel}";
    public static final String PUSH_CHANNEL_PARAMETER = "channel";
    private static final AnnotationLiteral<WebsocketEvent.Opened> OPENED = new AnnotationLiteral<WebsocketEvent.Opened>(){
        private static final long serialVersionUID = 2789324L;
    };
    private static final AnnotationLiteral<WebsocketEvent.Closed> CLOSED = new AnnotationLiteral<WebsocketEvent.Closed>(){
        private static final long serialVersionUID = 38450203L;
    };

    public void onOpen(Session session, EndpointConfig config) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        if (Boolean.TRUE.equals(config.getUserProperties().get("oam.websocket.valid")) && WebsocketApplicationSessionHolder.addOrUpdateSession(channelToken, session)) {
            session.setMaxIdleTimeout(config.getUserProperties().getOrDefault("oam.websocket.maxIdleTimeout", 300000L).longValue());
            Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
            BeanManager beanManager = CDI.current().getBeanManager();
            beanManager.getEvent().select(new Annotation[]{OPENED}).fire((Object)new WebsocketEvent(channel, user, null));
            session.getUserProperties().put("oam.websocket.SR", new WebsocketSessionClusterSerializedRestore(channelToken));
        } else {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Websocket connection not registered in current session"));
            }
            catch (IOException ex) {
                this.onError(session, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
        try {
            BeanManager beanManager = CDI.current().getBeanManager();
            beanManager.getEvent().select(new Annotation[]{CLOSED}).fire((Object)new WebsocketEvent(channel, user, closeReason.getCloseCode()));
        }
        catch (Exception exception) {
        }
        finally {
            WebsocketApplicationSessionHolder.removeSession(channelToken);
        }
    }

    public void onError(Session session, Throwable ex) {
        if (session.isOpen()) {
            session.getUserProperties().put(Throwable.class.getName(), ex);
        }
    }
}

