/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.faces.context.ExternalContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;

public class CDIInjectionProviderImpl
extends InjectionProvider {
    private BeanManager beanManager;

    public CDIInjectionProviderImpl(ExternalContext externalContext) {
        this.beanManager = CDIUtils.getBeanManager(externalContext);
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException {
        AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = this.beanManager.getInjectionTargetFactory(annoType).createInjectionTarget(null);
        CreationalContext creationalContext = this.beanManager.createCreationalContext(null);
        target.inject(instance, creationalContext);
        return creationalContext;
    }

    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException {
        AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = this.beanManager.getInjectionTargetFactory(annoType).createInjectionTarget(null);
        target.postConstruct(instance);
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException {
        if (creationMetaData instanceof CreationalContext) {
            AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
            InjectionTarget target = this.beanManager.getInjectionTargetFactory(annoType).createInjectionTarget(null);
            target.preDestroy(instance);
            ((CreationalContext)creationMetaData).release();
        }
    }
}

