/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.impl.AllAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.NoAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.NoInjectionAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.ResourceAnnotationInjectionProvider;

public class DefaultInjectionProviderFactory
extends InjectionProviderFactory {
    private static Logger log = Logger.getLogger(DefaultInjectionProviderFactory.class.getName());
    public static final String INJECTION_PROVIDER_INSTANCE_KEY = InjectionProvider.class.getName() + ".INJECTION_PROVIDER_INSTANCE";
    public static final String INJECTION_PROVIDER = InjectionProvider.class.getName();

    @Override
    public InjectionProvider getInjectionProvider(ExternalContext externalContext) {
        InjectionProvider lifecycleProvider = null;
        if (externalContext == null) {
            log.info("No ExternalContext using fallback InjectionProvider.");
            lifecycleProvider = this.resolveFallbackInjectionProvider();
        } else {
            lifecycleProvider = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
        }
        if (lifecycleProvider == null) {
            if (!this.resolveInjectionProviderFromExternalContext(externalContext)) {
                if (!this.resolveInjectionProviderFromService(externalContext)) {
                    lifecycleProvider = this.resolveFallbackInjectionProvider();
                    externalContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, lifecycleProvider);
                } else {
                    lifecycleProvider = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
                }
            } else {
                lifecycleProvider = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
            }
            log.info("Using InjectionProvider " + lifecycleProvider.getClass().getName());
        }
        return lifecycleProvider;
    }

    @Override
    public void release() {
    }

    private boolean resolveInjectionProviderFromExternalContext(ExternalContext externalContext) {
        try {
            Object obj;
            String lifecycleProvider = externalContext.getInitParameter(INJECTION_PROVIDER);
            if (lifecycleProvider != null && (obj = this.createClass(lifecycleProvider, externalContext)) instanceof InjectionProvider) {
                externalContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, obj);
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        return false;
    }

    private boolean resolveInjectionProviderFromService(ExternalContext externalContext) {
        boolean returnValue = false;
        final ExternalContext extContext = externalContext;
        try {
            if (System.getSecurityManager() != null) {
                returnValue = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                        List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(extContext).getServiceProviderList(INJECTION_PROVIDER);
                        for (String className : classList) {
                            InjectionProvider discoverableInjectionProvider;
                            Object obj = DefaultInjectionProviderFactory.this.createClass(className, extContext);
                            if (!InjectionProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableInjectionProvider = (InjectionProvider)obj).isAvailable()) continue;
                            extContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, discoverableInjectionProvider);
                            return true;
                        }
                        return false;
                    }
                });
            } else {
                List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(extContext).getServiceProviderList(INJECTION_PROVIDER);
                for (String className : classList) {
                    InjectionProvider discoverableInjectionProvider;
                    Object obj = this.createClass(className, extContext);
                    if (!InjectionProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableInjectionProvider = (InjectionProvider)obj).isAvailable()) continue;
                    extContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, discoverableInjectionProvider);
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classList) {
        }
        catch (NoClassDefFoundError classList) {
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException(e);
        }
        return returnValue;
    }

    private Object createClass(String className, ExternalContext externalContext) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        try {
            return ClassUtils.newInstance(clazz, new Class[]{ExternalContext.class}, externalContext);
        }
        catch (NoSuchMethodException e) {
            return ClassUtils.newInstance(clazz);
        }
    }

    private InjectionProvider resolveFallbackInjectionProvider() {
        return this.resolveFallbackInjectionProvider(FacesContext.getCurrentInstance().getExternalContext());
    }

    private InjectionProvider resolveFallbackInjectionProvider(ExternalContext externalContext) {
        try {
            ClassUtils.classForName("jakarta.annotation.PreDestroy");
        }
        catch (ClassNotFoundException e) {
            return new NoAnnotationInjectionProvider();
        }
        try {
            InitialContext context = new InitialContext();
            try {
                ClassUtils.classForName("jakarta.ejb.EJB");
                return new AllAnnotationInjectionProvider(context);
            }
            catch (ClassNotFoundException e) {
                return new ResourceAnnotationInjectionProvider(context);
            }
        }
        catch (NamingException e) {
            log.log(Level.SEVERE, "No InitialContext found. Using NoInjectionAnnotationProcessor.", e);
            return new NoInjectionAnnotationInjectionProvider();
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.SEVERE, "No InitialContext class definition found. Using NoInjectionAnnotationProcessor.");
            return new NoInjectionAnnotationInjectionProvider();
        }
    }
}

