/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util;

import java.util.Set;
import javax.faces.context.FacesContext;

public class ViewProtectionUtils {
    public static boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public static boolean isViewProtected(FacesContext context, String viewId) {
        Set protectedViews = context.getApplication().getViewHandler().getProtectedViewsUnmodifiable();
        if (!protectedViews.isEmpty()) {
            boolean matchFound = false;
            for (String urlPattern : protectedViews) {
                if (!ViewProtectionUtils.matchPattern(viewId, urlPattern)) continue;
                matchFound = true;
                break;
            }
            return matchFound;
        }
        return false;
    }
}

