/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;

public class HtmlHiddenRenderer
extends HtmlRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIInput.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        String clientId = uiComponent.getClientId(facesContext);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String value = RendererUtils.getStringValue(facesContext, uiComponent);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)uiComponent, submittedValue);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (!(component instanceof UIInput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
        HtmlRendererUtils.decodeUIInput(facesContext, component);
    }
}

