/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.ViewScopeProvider;

public class MyFacesHttpSessionListener
implements HttpSessionListener {
    public static final String APPLICATION_MAP_KEY = MyFacesHttpSessionListener.class.getName();
    private ViewScopeProvider viewScopeProvider = null;
    private FacesFlowProvider facesFlowProvider = null;

    public void setViewScopeProvider(ViewScopeProvider viewScopeProvider) {
        this.viewScopeProvider = viewScopeProvider;
    }

    public void setFacesFlowProvider(FacesFlowProvider facesFlowProvider) {
        this.facesFlowProvider = facesFlowProvider;
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            if (this.viewScopeProvider != null) {
                this.viewScopeProvider.onSessionDestroyed();
            }
            if (this.facesFlowProvider != null) {
                this.facesFlowProvider.onSessionDestroyed();
            }
        } else {
            try {
                ServletContext servletContext = event.getSession().getServletContext();
                StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                if (this.viewScopeProvider != null) {
                    this.viewScopeProvider.onSessionDestroyed();
                }
                if (this.facesFlowProvider != null) {
                    this.facesFlowProvider.onSessionDestroyed();
                }
            }
            finally {
                if (facesContext != null) {
                    facesContext.release();
                }
            }
        }
    }
}

