/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.context.FacesContext;
import org.apache.myfaces.view.facelets.el.ELText;

public class RequestViewMetadata
implements Serializable {
    public static final String RESOURCE_DEPENDENCY_KEY = "oam.component.resource.RDK";
    private Map<Class<?>, Boolean> processedClasses = new HashMap();
    private Map<ResourceDependency, Boolean> addedResources;
    private Map<Class<?>, Boolean> initialProcessedClasses = null;
    private Map<ResourceDependency, Boolean> initialAddedResources = null;

    public RequestViewMetadata cloneInstance() {
        RequestViewMetadata rvm = new RequestViewMetadata();
        rvm.initialProcessedClasses = new HashMap(this.initialProcessedClasses != null ? this.initialProcessedClasses : this.processedClasses);
        if (this.initialAddedResources != null) {
            rvm.initialAddedResources = new HashMap<ResourceDependency, Boolean>(this.initialAddedResources);
        } else if (this.addedResources != null) {
            rvm.initialAddedResources = new HashMap<ResourceDependency, Boolean>(this.addedResources);
        }
        return rvm;
    }

    public boolean isResourceDependencyAlreadyProcessed(ResourceDependency dependency) {
        if (this.initialAddedResources != null && this.initialAddedResources.containsKey(dependency)) {
            return true;
        }
        if (this.addedResources == null) {
            return false;
        }
        return this.addedResources.containsKey(dependency);
    }

    public void setResourceDependencyAsProcessed(ResourceDependency dependency) {
        if (this.addedResources == null) {
            this.addedResources = new HashMap<ResourceDependency, Boolean>();
        }
        this.addedResources.put(dependency, true);
    }

    public boolean isClassAlreadyProcessed(Class<?> inspectedClass) {
        if (this.initialProcessedClasses != null && this.initialProcessedClasses.containsKey(inspectedClass)) {
            return true;
        }
        return this.processedClasses.containsKey(inspectedClass);
    }

    public void setClassProcessed(Class<?> inspectedClass) {
        this.processedClasses.put(inspectedClass, Boolean.TRUE);
    }

    public Map<String, List<ResourceDependency>> getResourceDependencyAnnotations(FacesContext context) {
        List list;
        String target;
        if (this.initialAddedResources == null && this.addedResources == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ResourceDependency>> map = new HashMap<String, List<ResourceDependency>>();
        if (this.initialAddedResources != null) {
            for (ResourceDependency annotation : this.initialAddedResources.keySet()) {
                target = annotation.target();
                target = target != null && target.length() > 0 ? ELText.parse(context.getApplication().getExpressionFactory(), context.getELContext(), target).toString(context.getELContext()) : "head";
                list = map.computeIfAbsent(target, k -> new ArrayList());
                list.add(annotation);
            }
        }
        if (this.addedResources != null) {
            for (ResourceDependency annotation : this.addedResources.keySet()) {
                target = annotation.target();
                target = target != null && target.length() > 0 ? ELText.parse(context.getApplication().getExpressionFactory(), context.getELContext(), target).toString(context.getELContext()) : "head";
                list = map.computeIfAbsent(target, k -> new ArrayList());
                list.add(annotation);
            }
        }
        return map;
    }
}

