/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.impl.DefaultServiceProviderFinder;

public class ServiceProviderFinderFactory {
    private static final String SERVICE_PROVIDER_KEY = "org.apache.myfaces.spi.ServiceProviderFinder";
    private static final String SERVICE_PROVIDER_FINDER_PARAM = "org.apache.myfaces.SERVICE_PROVIDER_FINDER";

    public static ServiceProviderFinder getServiceProviderFinder(ExternalContext ectx) {
        ServiceProviderFinder slp = (ServiceProviderFinder)ectx.getApplicationMap().get(SERVICE_PROVIDER_KEY);
        if (slp == null) {
            slp = ServiceProviderFinderFactory._getServiceProviderFinderFromInitParam(ectx);
            if (slp == null) {
                slp = new DefaultServiceProviderFinder();
            }
            ServiceProviderFinderFactory.setServiceProviderFinder(ectx, slp);
        }
        return slp;
    }

    public static void setServiceProviderFinder(ExternalContext ectx, ServiceProviderFinder slp) {
        ectx.getApplicationMap().put(SERVICE_PROVIDER_KEY, slp);
    }

    public static void setServiceProviderFinder(ServletContext ctx, ServiceProviderFinder slp) {
        ctx.setAttribute(SERVICE_PROVIDER_KEY, (Object)slp);
    }

    private static ServiceProviderFinder _getServiceProviderFinderFromInitParam(ExternalContext context) {
        String initializerClassName = context.getInitParameter(SERVICE_PROVIDER_FINDER_PARAM);
        if (initializerClassName != null) {
            try {
                Class clazz = ClassUtils.classForName(initializerClassName);
                if (!ServiceProviderFinder.class.isAssignableFrom(clazz)) {
                    throw new FacesException("Class " + clazz + " does not implement ServiceProviderFinder");
                }
                return (ServiceProviderFinder)ClassUtils.newInstance(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Could not find class of specified ServiceProviderFinder", cnfe);
            }
        }
        return null;
    }
}

