/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.STATE_SAVING_METHOD";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    private Boolean _savingStateInClient = null;

    public SerializedView saveSerializedView(FacesContext context) {
        return null;
    }

    public Object saveView(FacesContext context) {
        SerializedView serializedView = this.saveSerializedView(context);
        if (serializedView == null) {
            return null;
        }
        Object[] structureAndState = new Object[]{serializedView.getStructure(), serializedView.getState()};
        return structureAndState;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        return null;
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return null;
    }

    public void writeState(FacesContext context, SerializedView state) throws IOException {
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        if (!(state instanceof Object[])) {
            return;
        }
        Object[] structureAndState = (Object[])state;
        if (structureAndState.length < 2) {
            return;
        }
        this.writeState(context, new SerializedView(structureAndState[0], structureAndState[1]));
    }

    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return null;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    public boolean isSavingStateInClient(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._savingStateInClient != null) {
            return this._savingStateInClient;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("No state saving method defined, assuming default server state saving");
        } else if (stateSavingMethod.equals(STATE_SAVING_METHOD_CLIENT)) {
            this._savingStateInClient = Boolean.TRUE;
        } else if (stateSavingMethod.equals(STATE_SAVING_METHOD_SERVER)) {
            this._savingStateInClient = Boolean.FALSE;
        } else {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("Illegal state saving method '" + stateSavingMethod + "', default server state saving will be used");
        }
        return this._savingStateInClient;
    }

    public class SerializedView {
        private Object _structure;
        private Object _state;

        public SerializedView(Object structure, Object state) {
            this._structure = structure;
            this._state = state;
        }

        public Object getStructure() {
            return this._structure;
        }

        public Object getState() {
            return this._state;
        }
    }
}

