/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.ManagedBeanBuilder;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.el.ImplicitObject;
import org.apache.myfaces.el.Scope;

public class VariableResolverImpl
extends VariableResolver {
    private static final Log log = LogFactory.getLog((Class)VariableResolverImpl.class);
    private static final String BEANS_UNDER_CONSTRUCTION = "org.apache.myfaces.config.beansUnderConstruction";
    public static final Map s_standardImplicitObjects = new HashMap(32);
    protected final Map _implicitObjects = new HashMap(32);
    protected static final Map s_standardScopes;
    protected final Map _scopes;
    private RuntimeConfig _runtimeConfig;
    private ManagedBeanBuilder beanBuilder;

    public VariableResolverImpl() {
        this._implicitObjects.putAll(s_standardImplicitObjects);
        this._scopes = new HashMap(16);
        this._scopes.putAll(s_standardScopes);
        this.beanBuilder = new ManagedBeanBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolveVariable(FacesContext facesContext, String name) {
        if (name == null || name.length() == 0) {
            throw new ReferenceSyntaxException("Varible name is null or empty");
        }
        Object implicitObject = this._implicitObjects.get(name);
        if (implicitObject != null) {
            if (implicitObject instanceof ImplicitObject) {
                return ((ImplicitObject)implicitObject).get(facesContext);
            }
            return implicitObject;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Object obj = requestMap.get(name);
        if (obj != null) {
            return obj;
        }
        obj = externalContext.getSessionMap().get(name);
        if (obj != null) {
            return obj;
        }
        obj = externalContext.getApplicationMap().get(name);
        if (obj != null) {
            return obj;
        }
        ManagedBean mbc = this.getRuntimeConfig(facesContext).getManagedBean(name);
        if (mbc != null) {
            String managedBeanName;
            ArrayList<String> beansUnderConstruction = (ArrayList<String>)requestMap.get(BEANS_UNDER_CONSTRUCTION);
            if (beansUnderConstruction == null) {
                beansUnderConstruction = new ArrayList<String>();
                requestMap.put(BEANS_UNDER_CONSTRUCTION, beansUnderConstruction);
            }
            if (beansUnderConstruction.contains(managedBeanName = mbc.getManagedBeanName())) {
                throw new FacesException("Detected cyclic reference to managedBean " + mbc.getManagedBeanName());
            }
            beansUnderConstruction.add(managedBeanName);
            try {
                obj = this.beanBuilder.buildManagedBean(facesContext, mbc);
            }
            finally {
                beansUnderConstruction.remove(managedBeanName);
            }
            String scopeKey = mbc.getManagedBeanScope();
            Scope scope = (Scope)this._scopes.get(scopeKey);
            if (scope == null) {
                log.error((Object)("Managed bean '" + name + "' has illegal scope: " + scopeKey));
            } else {
                scope.put(externalContext, name, obj);
            }
            if (obj == null && log.isDebugEnabled()) {
                log.debug((Object)("Variable '" + name + "' could not be resolved."));
            }
            return obj;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Variable '" + name + "' could not be resolved."));
        }
        return null;
    }

    protected RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this._runtimeConfig;
    }

    static {
        s_standardImplicitObjects.put("applicationScope", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getApplicationMap();
            }
        });
        s_standardImplicitObjects.put("cookie", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestCookieMap();
            }
        });
        s_standardImplicitObjects.put("facesContext", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext;
            }
        });
        s_standardImplicitObjects.put("header", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestHeaderMap();
            }
        });
        s_standardImplicitObjects.put("headerValues", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestHeaderValuesMap();
            }
        });
        s_standardImplicitObjects.put("initParam", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getInitParameterMap();
            }
        });
        s_standardImplicitObjects.put("param", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestParameterMap();
            }
        });
        s_standardImplicitObjects.put("paramValues", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestParameterValuesMap();
            }
        });
        s_standardImplicitObjects.put("requestScope", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestMap();
            }
        });
        s_standardImplicitObjects.put("sessionScope", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getExternalContext().getSessionMap();
            }
        });
        s_standardImplicitObjects.put("view", new ImplicitObject(){

            public Object get(FacesContext facesContext) {
                return facesContext.getViewRoot();
            }
        });
        s_standardScopes = new HashMap(16);
        s_standardScopes.put("request", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getRequestMap().put(name, obj);
            }
        });
        s_standardScopes.put("session", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getSessionMap().put(name, obj);
            }
        });
        s_standardScopes.put("application", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
                extContext.getApplicationMap().put(name, obj);
            }
        });
        s_standardScopes.put("none", new Scope(){

            public void put(ExternalContext extContext, String name, Object obj) {
            }
        });
    }
}

