/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.validator.CreditCardValidator;
import org.apache.myfaces.commons.validator.ValidatorBase;

public abstract class AbstractCreditCardValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.commons.validator.CreditCard";
    public static final String CREDITCARD_MESSAGE_ID = "org.apache.myfaces.commons.validator.Creditcard.INVALID";
    private int _initSum = 0;
    private CreditCardValidator creditCardValidator = null;

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        this.initValidator();
        if (!this.creditCardValidator.isValid(value.toString())) {
            Object[] args = new Object[]{value.toString()};
            throw new ValidatorException(this.getFacesMessage(CREDITCARD_MESSAGE_ID, args));
        }
    }

    private void initValidator() {
        if (this.isNone()) {
            this.creditCardValidator = new CreditCardValidator(0);
        } else {
            this.computeValidators();
            this.creditCardValidator = new CreditCardValidator(this._initSum);
        }
    }

    private void computeValidators() {
        if (this.isAmex()) {
            this._initSum = 1 + this._initSum;
        }
        if (this.isVisa()) {
            this._initSum = 2 + this._initSum;
        }
        if (this.isMastercard()) {
            this._initSum = 4 + this._initSum;
        }
        if (this.isDiscover()) {
            this._initSum = 8 + this._initSum;
        }
    }

    public abstract boolean isAmex();

    public abstract boolean isDiscover();

    public abstract boolean isMastercard();

    public abstract boolean isNone();

    public abstract boolean isVisa();

    public abstract void setAmex(boolean var1);

    public abstract void setDiscover(boolean var1);

    public abstract void setMastercard(boolean var1);

    public abstract void setNone(boolean var1);

    public abstract void setVisa(boolean var1);
}

