/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;

public class ProxyData {
    private final Proxy proxy;
    private final String proxyUser;
    private final char[] proxyPassword;

    public ProxyData(Proxy proxy) {
        this(proxy, null, null);
    }

    public ProxyData(Proxy proxy, String proxyUser, char[] proxyPassword) {
        if (Proxy.Type.DIRECT.equals((Object)proxy.type())) {
            throw new IllegalArgumentException("Proxy is direct");
        }
        if (!(proxy.address() instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Proxy does not have an InetSocketAddress");
        }
        this.proxy = proxy;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword == null ? null : (char[])proxyPassword.clone();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.proxy.address();
    }

    public Proxy.Type getType() {
        return this.proxy.type();
    }

    public String getUser() {
        return this.proxyUser;
    }

    public char[] getPassword() {
        return this.proxyPassword == null ? null : (char[])this.proxyPassword.clone();
    }

    public void clearPassword() {
        if (this.proxyPassword != null) {
            Arrays.fill(this.proxyPassword, '\u0000');
        }
    }
}

