/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.UnaryOperator;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.Parser;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.cling.internal.extension.io.CoreExtensionsStaxReader;
import org.apache.maven.cling.invoker.Utils;
import org.apache.maven.cling.props.MavenPropertiesLoader;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;

public abstract class BaseParser
implements Parser {
    public InvokerRequest parseInvocation(ParserRequest parserRequest) {
        List<Options> parsedOptions;
        Objects.requireNonNull(parserRequest);
        LocalContext context = new LocalContext(parserRequest);
        try {
            context.cwd = this.getCwd(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.cwd = Utils.getCanonicalPath(Paths.get(".", new String[0]));
            parserRequest.logger().error("Error determining working directory", (Throwable)e);
        }
        try {
            context.installationDirectory = this.getInstallationDirectory(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.installationDirectory = context.cwd;
            parserRequest.logger().error("Error determining installation directory", (Throwable)e);
        }
        try {
            context.userHomeDirectory = this.getUserHomeDirectory(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.userHomeDirectory = context.cwd;
            parserRequest.logger().error("Error determining user home directory", (Throwable)e);
        }
        try {
            context.topDirectory = this.getTopDirectory(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.topDirectory = context.cwd;
            parserRequest.logger().error("Error determining top directory", (Throwable)e);
        }
        try {
            context.rootDirectory = this.getRootDirectory(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.rootDirectory = context.cwd;
            parserRequest.logger().error("Error determining root directory", (Throwable)e);
        }
        try {
            parsedOptions = this.parseCliOptions(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            parsedOptions = List.of(this.emptyOptions());
            parserRequest.logger().error("Error parsing program arguments", (Throwable)e);
        }
        try {
            context.options = this.assembleOptions(parsedOptions);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.options = this.emptyOptions();
            parserRequest.logger().error("Error assembling program arguments", (Throwable)e);
        }
        try {
            context.systemProperties = this.populateSystemProperties(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.systemProperties = new HashMap<String, String>();
            parserRequest.logger().error("Error populating system properties", (Throwable)e);
        }
        try {
            context.userProperties = this.populateUserProperties(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            context.userProperties = new HashMap<String, String>();
            parserRequest.logger().error("Error populating user properties", (Throwable)e);
        }
        UnaryOperator[] unaryOperatorArray = new UnaryOperator[3];
        unaryOperatorArray[0] = context.extraInterpolationSource()::get;
        unaryOperatorArray[1] = context.userProperties::get;
        unaryOperatorArray[2] = context.systemProperties::get;
        context.options = context.options.interpolate(Interpolator.chain((UnaryOperator[])unaryOperatorArray));
        try {
            context.extensions = this.readCoreExtensionsDescriptor(context);
        }
        catch (Exception e) {
            context.parsingFailed = true;
            parserRequest.logger().error("Error reading core extensions descriptor", (Throwable)e);
        }
        if (!context.parsingFailed) {
            this.validate(context);
        }
        return this.getInvokerRequest(context);
    }

    protected void validate(LocalContext context) {
        Options options = context.options;
        options.failOnSeverity().ifPresent(severity -> {
            String c = severity.toLowerCase(Locale.ENGLISH);
            if (!Arrays.asList("warn", "warning", "error").contains(c)) {
                context.parsingFailed = true;
                context.parserRequest.logger().error("Invalid fail on severity threshold '" + c + "'. Supported values are 'WARN', 'WARNING' and 'ERROR'.");
            }
        });
        options.altUserSettings().ifPresent(userSettings -> this.failIfFileNotExists(context, (String)userSettings, "The specified user settings file does not exist"));
        options.altProjectSettings().ifPresent(projectSettings -> this.failIfFileNotExists(context, (String)projectSettings, "The specified project settings file does not exist"));
        options.altInstallationSettings().ifPresent(installationSettings -> this.failIfFileNotExists(context, (String)installationSettings, "The specified installation settings file does not exist"));
        options.altUserToolchains().ifPresent(userToolchains -> this.failIfFileNotExists(context, (String)userToolchains, "The specified user toolchains file does not exist"));
        options.altInstallationToolchains().ifPresent(installationToolchains -> this.failIfFileNotExists(context, (String)installationToolchains, "The specified installation toolchains file does not exist"));
        options.color().ifPresent(color -> {
            String c = color.toLowerCase(Locale.ENGLISH);
            if (!Arrays.asList("always", "yes", "force", "never", "no", "none", "auto", "tty", "if-tty").contains(c)) {
                context.parsingFailed = true;
                context.parserRequest.logger().error("Invalid color configuration value '" + c + "'. Supported values are 'auto', 'always', 'never'.");
            }
        });
    }

    protected void failIfFileNotExists(LocalContext context, String fileName, String message) {
        Path path = context.cwd.resolve(fileName);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            context.parsingFailed = true;
            context.parserRequest.logger().error(message + ": " + String.valueOf(path));
        }
    }

    protected abstract Options emptyOptions();

    protected abstract InvokerRequest getInvokerRequest(LocalContext var1);

    protected Path getCwd(LocalContext context) {
        if (context.parserRequest.cwd() != null) {
            Path result = Utils.getCanonicalPath(context.parserRequest.cwd());
            context.systemPropertiesOverrides.put("user.dir", result.toString());
            return result;
        }
        Path result = Utils.getCanonicalPath(Paths.get(System.getProperty("user.dir"), new String[0]));
        this.mayOverrideDirectorySystemProperty(context, "user.dir", result);
        return result;
    }

    protected Path getInstallationDirectory(LocalContext context) {
        if (context.parserRequest.mavenHome() != null) {
            Path result = Utils.getCanonicalPath(context.parserRequest.mavenHome());
            context.systemPropertiesOverrides.put("maven.home", result.toString());
            return result;
        }
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome == null) {
            throw new IllegalStateException("local mode requires maven.home Java System Property set");
        }
        Path result = Utils.getCanonicalPath(Paths.get(mavenHome, new String[0]));
        this.mayOverrideDirectorySystemProperty(context, "maven.home", result);
        return result;
    }

    protected Path getUserHomeDirectory(LocalContext context) {
        if (context.parserRequest.userHome() != null) {
            Path result = Utils.getCanonicalPath(context.parserRequest.userHome());
            context.systemPropertiesOverrides.put("user.home", result.toString());
            return result;
        }
        Path result = Utils.getCanonicalPath(Paths.get(System.getProperty("user.home"), new String[0]));
        this.mayOverrideDirectorySystemProperty(context, "user.home", result);
        return result;
    }

    protected void mayOverrideDirectorySystemProperty(LocalContext context, String javaSystemPropertyKey, Path value) {
        String valueString = value.toString();
        if (!Objects.equals(System.getProperty(javaSystemPropertyKey), valueString)) {
            context.systemPropertiesOverrides.put(javaSystemPropertyKey, valueString);
        }
    }

    protected Path getTopDirectory(LocalContext context) {
        Path topDirectory = Objects.requireNonNull(context.cwd);
        boolean isAltFile = false;
        for (String arg : context.parserRequest.args()) {
            if (isAltFile) {
                Path path = topDirectory.resolve(Utils.stripLeadingAndTrailingQuotes(arg));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    topDirectory = path;
                    break;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    topDirectory = path.getParent();
                    if (Files.isDirectory(topDirectory, new LinkOption[0])) break;
                    throw new IllegalArgumentException("Directory " + String.valueOf(topDirectory) + " extracted from the -f/--file command-line argument " + arg + " does not exist");
                }
                throw new IllegalArgumentException("POM file " + arg + " specified with the -f/--file command line argument does not exist");
            }
            isAltFile = arg.equals("-f") || arg.equals("--file");
        }
        return Utils.getCanonicalPath(topDirectory);
    }

    @Nullable
    protected Path getRootDirectory(LocalContext context) {
        return Utils.findRoot(context.topDirectory);
    }

    protected Map<String, String> populateSystemProperties(LocalContext context) {
        String[] versionElements;
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        boolean snapshot = mavenVersion.endsWith("SNAPSHOT");
        if (snapshot && (mavenVersion = mavenVersion.substring(0, mavenVersion.length() - "SNAPSHOT".length())).endsWith("-")) {
            mavenVersion = mavenVersion.substring(0, mavenVersion.length() - 1);
        }
        if ((versionElements = mavenVersion.split("\\.")).length != 3) {
            throw new IllegalStateException("Maven version is expected to have 3 segments: '" + mavenVersion + "'");
        }
        systemProperties.setProperty("maven.version.major", versionElements[0]);
        systemProperties.setProperty("maven.version.minor", versionElements[1]);
        systemProperties.setProperty("maven.version.patch", versionElements[2]);
        systemProperties.setProperty("maven.version.snapshot", Boolean.toString(snapshot));
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
        Map<String, String> result = Utils.toMap(systemProperties);
        result.putAll(context.systemPropertiesOverrides);
        return result;
    }

    protected Map<String, String> populateUserProperties(LocalContext context) {
        Properties userProperties = new Properties();
        Map userSpecifiedProperties = context.options.userProperties().orElse(new HashMap());
        Map<String, String> paths = context.extraInterpolationSource();
        UnaryOperator[] unaryOperatorArray = new UnaryOperator[3];
        unaryOperatorArray[0] = paths::get;
        unaryOperatorArray[1] = Utils.prefix("cli.", userSpecifiedProperties::get);
        unaryOperatorArray[2] = context.systemProperties::get;
        UnaryOperator<String> callback = Utils.or(unaryOperatorArray);
        Path mavenConf = context.systemProperties.get("maven.installation.conf") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.installation.conf")) : (context.systemProperties.get("maven.conf") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.conf")) : (context.systemProperties.get("maven.home") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.home")).resolve("conf") : context.installationDirectory.resolve("")));
        Path propertiesFile = mavenConf.resolve("maven.properties");
        try {
            MavenPropertiesLoader.loadProperties(userProperties, propertiesFile, callback, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading properties from " + String.valueOf(propertiesFile), e);
        }
        userProperties.putAll((Map<?, ?>)userSpecifiedProperties);
        return Utils.toMap(userProperties);
    }

    protected abstract List<Options> parseCliOptions(LocalContext var1);

    protected abstract Options assembleOptions(List<Options> var1);

    protected List<CoreExtension> readCoreExtensionsDescriptor(LocalContext context) {
        String installationExtensionsFile = context.userProperties.get("maven.installation.extensions");
        ArrayList<CoreExtension> installationExtensions = new ArrayList<CoreExtension>(this.readCoreExtensionsDescriptorFromFile(context.installationDirectory.resolve(installationExtensionsFile)));
        String userExtensionsFile = context.userProperties.get("maven.user.extensions");
        ArrayList<CoreExtension> userExtensions = new ArrayList<CoreExtension>(this.readCoreExtensionsDescriptorFromFile(context.userHomeDirectory.resolve(userExtensionsFile)));
        String projectExtensionsFile = context.userProperties.get("maven.project.extensions");
        ArrayList<CoreExtension> projectExtensions = new ArrayList<CoreExtension>(this.readCoreExtensionsDescriptorFromFile(context.cwd.resolve(projectExtensionsFile)));
        HashMap<String, String> gas = new HashMap<String, String>();
        ArrayList<String> conflicts = new ArrayList<String>();
        ArrayList<CoreExtension> coreExtensions = new ArrayList<CoreExtension>(installationExtensions.size() + userExtensions.size() + projectExtensions.size());
        coreExtensions.addAll(this.mergeExtensions(installationExtensions, installationExtensionsFile, gas, conflicts));
        coreExtensions.addAll(this.mergeExtensions(userExtensions, userExtensionsFile, gas, conflicts));
        coreExtensions.addAll(this.mergeExtensions(projectExtensions, projectExtensionsFile, gas, conflicts));
        if (!conflicts.isEmpty()) {
            throw new IllegalStateException("Extension conflicts: " + String.join((CharSequence)"; ", conflicts));
        }
        return coreExtensions;
    }

    private List<CoreExtension> mergeExtensions(List<CoreExtension> extensions, String extensionsSource, Map<String, String> gas, List<String> conflicts) {
        for (CoreExtension extension : extensions) {
            String ga = extension.getGroupId() + ":" + extension.getArtifactId();
            if (gas.containsKey(ga)) {
                conflicts.add(ga + " from " + extensionsSource + " already specified in " + gas.get(ga));
                continue;
            }
            gas.put(ga, extensionsSource);
        }
        return extensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<CoreExtension> readCoreExtensionsDescriptorFromFile(Path extensionsFile) {
        List list;
        if (extensionsFile == null || !Files.exists(extensionsFile, new LinkOption[0])) return List.of();
        InputStream is = Files.newInputStream(extensionsFile, new OpenOption[0]);
        try {
            list = new CoreExtensionsStaxReader().read(is, true).getExtensions();
            if (is == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLStreamException e) {
                throw new IllegalArgumentException("Failed to parse extensions file: " + String.valueOf(extensionsFile), e);
            }
        }
        is.close();
        return list;
    }

    public static class LocalContext {
        public final ParserRequest parserRequest;
        public final Map<String, String> systemPropertiesOverrides;
        public boolean parsingFailed = false;
        public Path cwd;
        public Path installationDirectory;
        public Path userHomeDirectory;
        public Map<String, String> systemProperties;
        public Map<String, String> userProperties;
        public Path topDirectory;
        @Nullable
        public Path rootDirectory;
        public List<CoreExtension> extensions;
        public Options options;

        public LocalContext(ParserRequest parserRequest) {
            this.parserRequest = parserRequest;
            this.systemPropertiesOverrides = new HashMap<String, String>();
        }

        public Map<String, String> extraInterpolationSource() {
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("session.topDirectory", this.topDirectory.toString());
            if (this.rootDirectory != null) {
                extra.put("session.rootDirectory", this.rootDirectory.toString());
            }
            return extra;
        }
    }
}

