/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver;

import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.api.metadata.Metadata;
import org.apache.maven.impl.resolver.MavenMetadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

abstract class MavenSnapshotMetadata
extends MavenMetadata {
    static final String SNAPSHOT = "SNAPSHOT";
    protected final Collection<Artifact> artifacts = new ArrayList<Artifact>();

    protected MavenSnapshotMetadata(Metadata metadata, Path path, Instant timestamp) {
        super(metadata, path, timestamp);
    }

    protected static Metadata createRepositoryMetadata(Artifact artifact) {
        return Metadata.newBuilder().modelVersion("1.1.0").groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).version(artifact.getBaseVersion()).build();
    }

    public void bind(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public Object getKey() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    protected String getKey(String classifier, String extension) {
        return classifier + ":" + extension;
    }

    public String getGroupId() {
        return this.metadata.getGroupId();
    }

    public String getArtifactId() {
        return this.metadata.getArtifactId();
    }

    public String getVersion() {
        return this.metadata.getVersion();
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

