/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class PathConflictResolver
extends ConflictResolver {
    public static final String CONFIG_PROP_SHOW_CYCLES_IN_STANDARD_VERBOSITY = "aether.conflictResolver.path.showCyclesInStandardVerbosity";
    public static final boolean DEFAULT_SHOW_CYCLES_IN_STANDARD_VERBOSITY = false;
    private final ConflictResolver.VersionSelector versionSelector;
    private final ConflictResolver.ScopeSelector scopeSelector;
    private final ConflictResolver.ScopeDeriver scopeDeriver;
    private final ConflictResolver.OptionalitySelector optionalitySelector;

    public PathConflictResolver(ConflictResolver.VersionSelector versionSelector, ConflictResolver.ScopeSelector scopeSelector, ConflictResolver.OptionalitySelector optionalitySelector, ConflictResolver.ScopeDeriver scopeDeriver) {
        this.versionSelector = Objects.requireNonNull(versionSelector, "version selector cannot be null");
        this.scopeSelector = Objects.requireNonNull(scopeSelector, "scope selector cannot be null");
        this.optionalitySelector = Objects.requireNonNull(optionalitySelector, "optionality selector cannot be null");
        this.scopeDeriver = Objects.requireNonNull(scopeDeriver, "scope deriver cannot be null");
    }

    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        Map stats = (Map)context.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        Collection conflictIdCycles = (Collection)context.get(TransformationContextKeys.CYCLIC_CONFLICT_IDS);
        if (conflictIdCycles == null) {
            throw new RepositoryException("conflict id cycles have not been identified");
        }
        Map conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS);
        if (conflictIds == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        State state = new State(ConflictResolver.getVerbosity(context.getSession()), ConfigUtils.getBoolean(context.getSession(), false, CONFIG_PROP_SHOW_CYCLES_IN_STANDARD_VERBOSITY), this.versionSelector.getInstance(node, context), this.scopeSelector.getInstance(node, context), this.scopeDeriver.getInstance(node, context), this.optionalitySelector.getInstance(node, context), conflictIds);
        state.build(node);
        for (String conflictId : sortedConflictIds) {
            List paths = (List)state.partitions.get(conflictId);
            if (paths.isEmpty()) continue;
            ConflictContext ctx = new ConflictContext(node, state.conflictIds, paths.stream().map(x$0 -> new ConflictItem((Path)x$0)).collect(Collectors.toList()), conflictId);
            state.versionSelector.selectVersion(ctx);
            if (ctx.winner == null) {
                throw new RepositoryException("conflict resolver did not select winner among " + ctx.items);
            }
            state.scopeSelector.selectScope(ctx);
            state.optionalitySelector.selectOptionality(ctx);
            Path winnerPath = ctx.winner.path;
            if (state.resolvedIds.containsKey(conflictId)) {
                throw new RepositoryException("conflict resolver already have winner for conflictId=" + conflictId + ": " + state.resolvedIds);
            }
            state.resolvedIds.put(conflictId, winnerPath);
            for (Path path : new ArrayList(paths)) {
                if (path == winnerPath) {
                    path.scope = ctx.scope;
                    path.optional = ctx.optional;
                }
                path.children.forEach(c -> ((Path)c).pull(0));
                path.derive(1, path == winnerPath);
                path.push(0);
            }
        }
        if (stats != null) {
            long time2 = System.nanoTime();
            stats.put("ConflictResolver.totalTime", time2 - time1);
            stats.put("ConflictResolver.conflictItemCount", state.partitions.values().stream().map(List::size).reduce(0, Integer::sum));
        }
        return node;
    }

    private static class State {
        private final ConflictResolver.Verbosity verbosity;
        private final boolean showCyclesInStandardVerbosity;
        private final ConflictResolver.VersionSelector versionSelector;
        private final ConflictResolver.ScopeSelector scopeSelector;
        private final ConflictResolver.ScopeDeriver scopeDeriver;
        private final ConflictResolver.OptionalitySelector optionalitySelector;
        private final Map<DependencyNode, String> conflictIds;
        private final Map<String, List<Path>> partitions;
        private final Map<String, Path> resolvedIds;

        private State(ConflictResolver.Verbosity verbosity, boolean showCyclesInStandardVerbosity, ConflictResolver.VersionSelector versionSelector, ConflictResolver.ScopeSelector scopeSelector, ConflictResolver.ScopeDeriver scopeDeriver, ConflictResolver.OptionalitySelector optionalitySelector, Map<DependencyNode, String> conflictIds) {
            this.verbosity = verbosity;
            this.showCyclesInStandardVerbosity = showCyclesInStandardVerbosity;
            this.versionSelector = versionSelector;
            this.scopeSelector = scopeSelector;
            this.scopeDeriver = scopeDeriver;
            this.optionalitySelector = optionalitySelector;
            this.conflictIds = conflictIds;
            this.partitions = new HashMap<String, List<Path>>();
            this.resolvedIds = new HashMap<String, Path>();
        }

        private void build(DependencyNode node) throws RepositoryException {
            Path root = new Path(this, node, null, false);
            this.gatherCRNodes(root);
        }

        private void gatherCRNodes(Path node) throws RepositoryException {
            List children = node.dn.getChildren();
            if (!children.isEmpty()) {
                List added = node.addChildren(children);
                for (Path child : added) {
                    if (child.cycle) continue;
                    this.gatherCRNodes(child);
                }
            }
        }
    }

    private static final class ConflictContext
    extends ConflictResolver.ConflictContext {
        private final DependencyNode root;
        private final Map<DependencyNode, String> conflictIds;
        private final Collection<ConflictResolver.ConflictItem> items;
        private final String conflictId;
        private ConflictItem winner;
        private String scope;
        private Boolean optional;

        private ConflictContext(DependencyNode root, Map<DependencyNode, String> conflictIds, Collection<ConflictItem> items, String conflictId) {
            this.root = root;
            this.conflictIds = conflictIds;
            this.items = Collections.unmodifiableCollection(items);
            this.conflictId = conflictId;
        }

        @Override
        public DependencyNode getRoot() {
            return this.root;
        }

        @Override
        public boolean isIncluded(DependencyNode node) {
            return this.conflictId.equals(this.conflictIds.get(node));
        }

        @Override
        public Collection<ConflictResolver.ConflictItem> getItems() {
            return this.items;
        }

        @Override
        public ConflictResolver.ConflictItem getWinner() {
            return this.winner;
        }

        @Override
        public void setWinner(ConflictResolver.ConflictItem winner) {
            this.winner = (ConflictItem)winner;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public Boolean getOptional() {
            return this.optional;
        }

        @Override
        public void setOptional(Boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            return this.winner + " @ " + this.scope + " < " + this.items;
        }
    }

    private static final class ConflictItem
    extends ConflictResolver.ConflictItem {
        private final Path path;
        private final List<DependencyNode> parent;
        private final Artifact artifact;
        private final DependencyNode node;
        private final int depth;
        private final String scope;
        private final int optionalities;

        private ConflictItem(Path path) {
            this.path = path;
            if (path.parent != null) {
                DependencyNode parent = path.parent.dn;
                this.parent = parent.getChildren();
                this.artifact = parent.getArtifact();
            } else {
                this.parent = null;
                this.artifact = null;
            }
            this.node = path.dn;
            this.depth = path.depth;
            this.scope = path.scope;
            this.optionalities = path.optional ? 2 : 1;
        }

        @Override
        public boolean isSibling(ConflictResolver.ConflictItem item) {
            return this.parent == ((ConflictItem)item).parent;
        }

        @Override
        public DependencyNode getNode() {
            return this.node;
        }

        @Override
        public Dependency getDependency() {
            return this.node.getDependency();
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public Collection<String> getScopes() {
            return Collections.singleton(this.scope);
        }

        @Override
        public int getOptionalities() {
            return this.optionalities;
        }

        public String toString() {
            return this.node + " @ " + this.depth + " < " + this.artifact;
        }
    }

    private static class Path {
        private final State state;
        private DependencyNode dn;
        private final String conflictId;
        private final Path parent;
        private final boolean cycle;
        private final int depth;
        private final List<Path> children;
        private String scope;
        private boolean optional;

        private Path(State state, DependencyNode dn, Path parent, boolean cycle) {
            this.state = state;
            this.dn = dn;
            this.conflictId = (String)state.conflictIds.get(dn);
            this.parent = parent;
            this.cycle = cycle;
            this.depth = parent != null ? parent.depth + 1 : 0;
            this.children = new ArrayList<Path>();
            this.pull(0);
            this.state.partitions.computeIfAbsent(this.conflictId, k -> new ArrayList()).add(this);
        }

        private void pull(int levels) {
            Dependency d = this.dn.getDependency();
            if (d != null) {
                this.scope = d.getScope();
                this.optional = d.isOptional();
            } else {
                this.scope = "";
                this.optional = false;
            }
            int newLevels = levels - 1;
            if (newLevels >= 0) {
                for (Path child : this.children) {
                    child.pull(newLevels);
                }
            }
        }

        private void derive(int levels, boolean winner) throws RepositoryException {
            int newLevels;
            if (!winner) {
                if (this.parent != null) {
                    if ((this.dn.getManagedBits() & 2) == 0) {
                        ScopeContext context = new ScopeContext(this.parent.scope, this.scope);
                        this.state.scopeDeriver.deriveScope(context);
                        this.scope = context.derivedScope;
                    }
                    if ((this.dn.getManagedBits() & 4) == 0 && !this.optional && this.parent.optional) {
                        this.optional = true;
                    }
                } else {
                    this.scope = "";
                    this.optional = false;
                }
            }
            if ((newLevels = levels - 1) >= 0) {
                for (Path child : this.children) {
                    child.derive(newLevels, false);
                }
            }
        }

        private void push(int levels) {
            int newLevels;
            if (this.parent != null) {
                Path winner = (Path)this.state.resolvedIds.get(this.conflictId);
                if (winner == null) {
                    throw new IllegalStateException("Winner selection did not happen for conflictId=" + this.conflictId);
                }
                if (!Objects.equals(winner.conflictId, this.conflictId)) {
                    throw new IllegalStateException("ConflictId mix-up: this=" + this.conflictId + " winner=" + winner.conflictId);
                }
                if (winner == this) {
                    if (this.dn.getDependency() != null) {
                        this.dn.setData((Object)"conflict.originalScope", (Object)this.dn.getDependency().getScope());
                        this.dn.setData((Object)"conflict.originalOptionality", (Object)this.dn.getDependency().getOptional());
                        this.dn.setScope(this.scope);
                        this.dn.setOptional(Boolean.valueOf(this.optional));
                    }
                } else {
                    this.moveOutOfScope();
                    boolean markLoser = false;
                    switch (this.state.verbosity) {
                        case NONE: {
                            this.parent.children.remove(this);
                            this.parent.dn.setChildren(new ArrayList(this.parent.dn.getChildren()));
                            this.parent.dn.getChildren().remove(this.dn);
                            this.children.clear();
                            break;
                        }
                        case STANDARD: {
                            boolean isRedundant;
                            String artifactId = ArtifactIdUtils.toId(this.dn.getArtifact());
                            String winnerArtifactId = ArtifactIdUtils.toId(winner.dn.getArtifact());
                            boolean bl = isRedundant = !Objects.equals(artifactId, winnerArtifactId) && this.relatedSiblingsCount(this.dn.getArtifact(), this.parent) > 1;
                            if (!this.state.showCyclesInStandardVerbosity) {
                                boolean bl2 = isRedundant = isRedundant || this.parent.isDirectDependencyOnPathToRoot(this.dn.getArtifact());
                            }
                            if (isRedundant) {
                                this.parent.children.remove(this);
                                this.parent.dn.setChildren(new ArrayList(this.parent.dn.getChildren()));
                                this.parent.dn.getChildren().remove(this.dn);
                                this.children.clear();
                                break;
                            }
                            DefaultDependencyNode dnCopy = new DefaultDependencyNode(this.dn);
                            dnCopy.setChildren(Collections.emptyList());
                            int idx = this.parent.dn.getChildren().indexOf(this.dn);
                            if (idx >= 0) {
                                this.parent.dn.getChildren().set(idx, dnCopy);
                            }
                            this.dn = dnCopy;
                            this.children.clear();
                            markLoser = true;
                            break;
                        }
                        case FULL: {
                            DefaultDependencyNode dnCopy = new DefaultDependencyNode(this.dn);
                            dnCopy.setChildren(new ArrayList(this.dn.getChildren()));
                            int idx = this.parent.dn.getChildren().indexOf(this.dn);
                            if (idx >= 0) {
                                this.parent.dn.getChildren().set(idx, dnCopy);
                            }
                            this.dn = dnCopy;
                            markLoser = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown " + (Object)((Object)this.state.verbosity));
                        }
                    }
                    if (markLoser) {
                        this.dn.setData((Object)"conflict.winner", (Object)winner.dn);
                        this.dn.setData((Object)"conflict.originalScope", (Object)this.dn.getDependency().getScope());
                        this.dn.setData((Object)"conflict.originalOptionality", (Object)this.dn.getDependency().getOptional());
                        this.dn.setScope(this.scope);
                        this.dn.setOptional(Boolean.valueOf(this.optional));
                    }
                }
            }
            if ((newLevels = levels - 1) >= 0 && !this.children.isEmpty()) {
                for (Path child : new ArrayList<Path>(this.children)) {
                    child.push(newLevels);
                }
            }
        }

        private boolean isDirectDependencyOnPathToRoot(Artifact artifact) {
            if (this.depth == 1 && ArtifactIdUtils.toVersionlessId(this.dn.getArtifact()).equals(ArtifactIdUtils.toVersionlessId(artifact))) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isDirectDependencyOnPathToRoot(artifact);
            }
            return false;
        }

        private int relatedSiblingsCount(Artifact artifact, Path parent) {
            String ga = artifact.getGroupId() + ":" + artifact.getArtifactId();
            return Math.toIntExact(parent.children.stream().map(n -> n.dn.getArtifact()).filter(a -> ga.equals(a.getGroupId() + ":" + a.getArtifactId())).count());
        }

        private void moveOutOfScope() {
            ((List)this.state.partitions.get(this.conflictId)).remove(this);
            for (Path child : this.children) {
                child.moveOutOfScope();
            }
        }

        private List<Path> addChildren(List<DependencyNode> children) throws RepositoryException {
            ArrayList<Path> added = new ArrayList<Path>(children.size());
            for (DependencyNode child : children) {
                String childConflictId = (String)this.state.conflictIds.get(child);
                boolean cycle = this.state.partitions.getOrDefault(childConflictId, Collections.emptyList()).stream().anyMatch(p -> p.dn.equals((Object)child));
                Path c = new Path(this.state, child, this, cycle);
                this.children.add(c);
                c.derive(0, false);
                added.add(c);
            }
            return added;
        }

        private void dump(String padding) {
            System.out.println(padding + this.dn + ": " + this.scope + "/" + this.optional);
            for (Path child : this.children) {
                child.dump(padding + "  ");
            }
        }

        public String toString() {
            return this.dn.toString();
        }
    }

    private static final class ScopeContext
    extends ConflictResolver.ScopeContext {
        private final String parentScope;
        private final String childScope;
        private String derivedScope;

        private ScopeContext(String parentScope, String childScope) {
            this.parentScope = parentScope != null ? parentScope : "";
            this.derivedScope = childScope != null ? childScope : "";
            this.childScope = childScope != null ? childScope : "";
        }

        @Override
        public String getParentScope() {
            return this.parentScope;
        }

        @Override
        public String getChildScope() {
            return this.childScope;
        }

        @Override
        public String getDerivedScope() {
            return this.derivedScope;
        }

        @Override
        public void setDerivedScope(String derivedScope) {
            this.derivedScope = derivedScope != null ? derivedScope : "";
        }
    }
}

