/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.building;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.building.Problem;
import org.apache.maven.building.ProblemCollector;
import org.apache.maven.building.ProblemCollectorFactory;
import org.apache.maven.building.Source;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingResult;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingException;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.io.ToolchainsWriter;
import org.apache.maven.toolchain.merge.MavenToolchainMerger;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    private MavenToolchainMerger toolchainsMerger = new MavenToolchainMerger();
    @Inject
    private ToolchainsWriter toolchainsWriter;
    @Inject
    private ToolchainsReader toolchainsReader;

    @Override
    public ToolchainsBuildingResult build(ToolchainsBuildingRequest request) throws ToolchainsBuildingException {
        ProblemCollector problems = ProblemCollectorFactory.newInstance(null);
        PersistedToolchains globalToolchains = this.readToolchains(request.getGlobalToolchainsSource(), request, problems);
        PersistedToolchains userToolchains = this.readToolchains(request.getUserToolchainsSource(), request, problems);
        this.toolchainsMerger.merge(userToolchains, globalToolchains, "global-level");
        problems.setSource("");
        userToolchains = this.interpolate(userToolchains, problems);
        if (this.hasErrors(problems.getProblems())) {
            throw new ToolchainsBuildingException(problems.getProblems());
        }
        return new DefaultToolchainsBuildingResult(userToolchains, problems.getProblems());
    }

    private PersistedToolchains interpolate(PersistedToolchains toolchains, ProblemCollector problems) {
        PersistedToolchains result;
        StringWriter stringWriter = new StringWriter(4096);
        try {
            this.toolchainsWriter.write(stringWriter, null, toolchains);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize toolchains to memory", e);
        }
        String serializedToolchains = stringWriter.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(Problem.Severity.WARNING, "Failed to use environment variables for interpolation: " + e.getMessage(), -1, -1, (Exception)e);
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            public Object execute(String expression, Object value) {
                if (value != null) {
                    value = value.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                    return value;
                }
                return null;
            }
        });
        try {
            serializedToolchains = interpolator.interpolate(serializedToolchains);
        }
        catch (InterpolationException e) {
            problems.add(Problem.Severity.ERROR, "Failed to interpolate toolchains: " + e.getMessage(), -1, -1, (Exception)((Object)e));
            return toolchains;
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.toolchains.io.isStrict", Boolean.FALSE);
            result = this.toolchainsReader.read(new StringReader(serializedToolchains), options);
        }
        catch (IOException e) {
            problems.add(Problem.Severity.ERROR, "Failed to interpolate toolchains: " + e.getMessage(), -1, -1, (Exception)e);
            return toolchains;
        }
        return result;
    }

    private PersistedToolchains readToolchains(Source toolchainsSource, ToolchainsBuildingRequest request, ProblemCollector problems) {
        PersistedToolchains toolchains;
        if (toolchainsSource == null) {
            return new PersistedToolchains();
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.toolchains.io.isStrict", Boolean.TRUE);
            try {
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
            }
            catch (ToolchainsParseException e) {
                options = Collections.singletonMap("org.apache.maven.toolchains.io.isStrict", Boolean.FALSE);
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
                problems.add(Problem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), (Exception)e);
            }
        }
        catch (ToolchainsParseException e) {
            problems.add(Problem.Severity.FATAL, "Non-parseable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), (Exception)e);
            return new PersistedToolchains();
        }
        catch (IOException e) {
            problems.add(Problem.Severity.FATAL, "Non-readable toolchains " + toolchainsSource.getLocation() + ": " + e.getMessage(), -1, -1, (Exception)e);
            return new PersistedToolchains();
        }
        return toolchains;
    }

    private boolean hasErrors(List<Problem> problems) {
        if (problems != null) {
            for (Problem problem : problems) {
                if (Problem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

