/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class XmlPlexusConfiguration
implements PlexusConfiguration {
    private XmlNode xmlNode;
    private PlexusConfiguration[] childrenCache;

    public static PlexusConfiguration toPlexusConfiguration(XmlNode node) {
        return new XmlPlexusConfiguration(node);
    }

    public XmlPlexusConfiguration(XmlNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    private synchronized void clearCache() {
        this.childrenCache = null;
    }

    private XmlNode convertToXmlNode(PlexusConfiguration config) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String attrName : config.getAttributeNames()) {
            String attrValue = config.getAttribute(attrName);
            if (attrValue == null) continue;
            attributes.put(attrName, attrValue);
        }
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        for (PlexusConfiguration child : config.getChildren()) {
            children.add(this.convertToXmlNode(child));
        }
        return XmlNode.newInstance((String)config.getName(), (String)config.getValue(), attributes, children, null);
    }

    public String getName() {
        return this.xmlNode.name();
    }

    public synchronized void setName(String name) {
        this.xmlNode = XmlNode.newBuilder().name(name).value(this.xmlNode.value()).attributes(this.xmlNode.attributes()).children(this.xmlNode.children()).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
    }

    public String getValue() {
        return this.xmlNode.value();
    }

    public String getValue(String defaultValue) {
        String value = this.xmlNode.value();
        return value != null ? value : defaultValue;
    }

    public synchronized void setValue(String value) {
        this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(value).attributes(this.xmlNode.attributes()).children(this.xmlNode.children()).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
    }

    public PlexusConfiguration setValueAndGetSelf(String value) {
        this.setValue(value);
        return this;
    }

    public synchronized void setAttribute(String name, String value) {
        HashMap<String, String> newAttributes = new HashMap<String, String>(this.xmlNode.attributes());
        if (value == null) {
            newAttributes.remove(name);
        } else {
            newAttributes.put(name, value);
        }
        this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(this.xmlNode.value()).attributes(newAttributes).children(this.xmlNode.children()).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
    }

    public String[] getAttributeNames() {
        return this.xmlNode.attributes().keySet().toArray(new String[0]);
    }

    public String getAttribute(String paramName) {
        return this.xmlNode.attribute(paramName);
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.xmlNode.attribute(name);
        return value != null ? value : defaultValue;
    }

    public PlexusConfiguration getChild(String child) {
        XmlNode childNode = this.xmlNode.child(child);
        if (childNode != null) {
            return new XmlPlexusConfiguration(childNode);
        }
        XmlNode emptyNode = XmlNode.newInstance((String)child, null, null, null, null);
        return new XmlPlexusConfiguration(emptyNode);
    }

    public PlexusConfiguration getChild(int i) {
        List children = this.xmlNode.children();
        if (i >= 0 && i < children.size()) {
            return new XmlPlexusConfiguration((XmlNode)children.get(i));
        }
        return null;
    }

    public synchronized PlexusConfiguration getChild(String child, boolean createChild) {
        XmlNode childNode = this.xmlNode.child(child);
        if (childNode == null) {
            if (createChild) {
                XmlNode newChild = XmlNode.newInstance((String)child);
                ArrayList<XmlNode> newChildren = new ArrayList<XmlNode>(this.xmlNode.children());
                newChildren.add(newChild);
                this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(this.xmlNode.value()).attributes(this.xmlNode.attributes()).children(newChildren).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
                this.clearCache();
                return new XmlPlexusConfiguration(newChild);
            }
            return null;
        }
        return new XmlPlexusConfiguration(childNode);
    }

    public synchronized PlexusConfiguration[] getChildren() {
        if (this.childrenCache == null) {
            List children = this.xmlNode.children();
            this.childrenCache = new PlexusConfiguration[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                this.childrenCache[i] = new XmlPlexusConfiguration((XmlNode)children.get(i));
            }
        }
        return (PlexusConfiguration[])this.childrenCache.clone();
    }

    public PlexusConfiguration[] getChildren(String name) {
        ArrayList<XmlPlexusConfiguration> result = new ArrayList<XmlPlexusConfiguration>();
        for (XmlNode child : this.xmlNode.children()) {
            if (!name.equals(child.name())) continue;
            result.add(new XmlPlexusConfiguration(child));
        }
        return result.toArray(new PlexusConfiguration[0]);
    }

    public synchronized void addChild(PlexusConfiguration configuration) {
        XmlNode newChild = this.convertToXmlNode(configuration);
        ArrayList<XmlNode> newChildren = new ArrayList<XmlNode>(this.xmlNode.children());
        newChildren.add(newChild);
        this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(this.xmlNode.value()).attributes(this.xmlNode.attributes()).children(newChildren).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
    }

    public synchronized PlexusConfiguration addChild(String name) {
        XmlNode newChild = XmlNode.newInstance((String)name);
        ArrayList<XmlNode> newChildren = new ArrayList<XmlNode>(this.xmlNode.children());
        newChildren.add(newChild);
        this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(this.xmlNode.value()).attributes(this.xmlNode.attributes()).children(newChildren).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
        return new XmlPlexusConfiguration(newChild);
    }

    public synchronized PlexusConfiguration addChild(String name, String value) {
        XmlNode newChild = XmlNode.newInstance((String)name, (String)value);
        ArrayList<XmlNode> newChildren = new ArrayList<XmlNode>(this.xmlNode.children());
        newChildren.add(newChild);
        this.xmlNode = XmlNode.newBuilder().name(this.xmlNode.name()).value(this.xmlNode.value()).attributes(this.xmlNode.attributes()).children(newChildren).namespaceUri(this.xmlNode.namespaceUri()).prefix(this.xmlNode.prefix()).inputLocation(this.xmlNode.inputLocation()).build();
        this.clearCache();
        return new XmlPlexusConfiguration(newChild);
    }

    public int getChildCount() {
        return this.xmlNode.children().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('<').append(this.getName());
        for (String a : this.getAttributeNames()) {
            buf.append(' ').append(a).append("=\"").append(this.getAttribute(a)).append('\"');
        }
        if (this.getChildCount() > 0) {
            buf.append('>');
            int size = this.getChildCount();
            for (int i = 0; i < size; ++i) {
                buf.append(this.getChild(i));
            }
            buf.append("</").append(this.getName()).append('>');
        } else if (null != this.getValue()) {
            buf.append('>').append(this.getValue()).append("</").append(this.getName()).append('>');
        } else {
            buf.append("/>");
        }
        return buf.append('\n').toString();
    }
}

