/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.query;

import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Policy;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Relationship;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

public final class PropertyQueryUtil {
    private PropertyQueryUtil() {
    }

    public static Object getProperty(StoredObject so, String propertyId, PropertyDefinition<?> pd, boolean cmis11) {
        ContentStream content = null;
        DocumentVersion ver = null;
        VersionedDocument verDoc = null;
        Folder folder = null;
        Document doc = null;
        Relationship rel = null;
        Policy pol = null;
        if (so instanceof Content) {
            content = ((Content)((Object)so)).getContent();
        }
        if (so instanceof DocumentVersion) {
            ver = (DocumentVersion)so;
        }
        if (so instanceof VersionedDocument) {
            verDoc = (VersionedDocument)so;
        }
        if (so instanceof Folder) {
            folder = (Folder)so;
        }
        if (so instanceof Document) {
            doc = (Document)so;
        }
        if (so instanceof Relationship) {
            rel = (Relationship)((Object)so);
        }
        if (so instanceof Policy) {
            pol = (Policy)((Object)so);
        }
        if (propertyId.equals("cmis:name")) {
            return so.getName();
        }
        if (propertyId.equals("cmis:objectId")) {
            return so.getId();
        }
        if (propertyId.equals("cmis:objectTypeId")) {
            return so.getTypeId();
        }
        if (propertyId.equals("cmis:baseTypeId")) {
            return null;
        }
        if (propertyId.equals("cmis:createdBy")) {
            return so.getCreatedBy();
        }
        if (propertyId.equals("cmis:creationDate")) {
            return so.getCreatedAt();
        }
        if (propertyId.equals("cmis:lastModifiedBy")) {
            return so.getModifiedBy();
        }
        if (propertyId.equals("cmis:lastModificationDate")) {
            return so.getModifiedAt();
        }
        if (propertyId.equals("cmis:changeToken")) {
            return so.getChangeToken();
        }
        if (cmis11 && propertyId.equals("cmis:description")) {
            return so.getDescription();
        }
        if (ver != null) {
            if (propertyId.equals("cmis:isMajorVersion")) {
                return ver.isMajor();
            }
            if (propertyId.equals("cmis:checkinComment")) {
                return ver.getCheckinComment();
            }
            if (propertyId.equals("cmis:versionLabel")) {
                return ver.getVersionLabel();
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutId")) {
                return ver.isPwc() ? ver.getId() : null;
            }
        }
        if (verDoc != null) {
            if (propertyId.equals("cmis:versionSeriesId")) {
                return verDoc.getId();
            }
            if (propertyId.equals("cmis:isVersionSeriesCheckedOut")) {
                return verDoc.isCheckedOut();
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutBy")) {
                return verDoc.getCheckedOutBy();
            }
        }
        if (null != content) {
            if (propertyId.equals("cmis:contentStreamFileName")) {
                return content.getFileName();
            }
            if (propertyId.equals("cmis:contentStreamLength")) {
                return content.getBigLength();
            }
            if (propertyId.equals("cmis:contentStreamMimeType")) {
                return content.getMimeType();
            }
        }
        if (folder != null && propertyId.equals("cmis:parentId")) {
            return folder.getParentId();
        }
        if (doc != null && propertyId.equals("cmis:isImmutable")) {
            return false;
        }
        if (rel != null) {
            if (propertyId.equals("cmis:sourceId")) {
                return rel.getSourceObjectId();
            }
            if (propertyId.equals("cmis:targetId")) {
                return rel.getTargetObjectId();
            }
        }
        if (pol != null && propertyId.equals("cmis:policyText")) {
            return pol.getPolicyText();
        }
        PropertyData<?> lVal = so.getProperties().get(propertyId);
        if (null == lVal) {
            return null;
        }
        if (pd.getCardinality() == Cardinality.SINGLE) {
            return lVal.getFirstValue();
        }
        return lVal.getValues();
    }
}

