/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Optional;

public class JettySettings {
    private final Optional<Integer> acceptors;
    private final Optional<Integer> acceptQueueSize;
    private final Optional<Integer> requestHeaderSize;

    private JettySettings(Optional<Integer> acceptors, Optional<Integer> acceptQueueSize, Optional<Integer> requestHeaderSize) {
        this.acceptors = acceptors;
        this.acceptQueueSize = acceptQueueSize;
        this.requestHeaderSize = requestHeaderSize;
    }

    public Optional<Integer> getAcceptors() {
        return this.acceptors;
    }

    public Optional<Integer> getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public Optional<Integer> getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public String toString() {
        return "JettySettings{acceptors=" + this.acceptors + ", acceptQueueSize=" + this.acceptQueueSize + ", requestHeaderSize=" + this.requestHeaderSize + '}';
    }

    public static class Builder {
        private Integer acceptors;
        private Integer acceptQueueSize;
        private Integer requestHeaderSize;

        private Builder() {
        }

        public static Builder aJettySettings() {
            return new Builder();
        }

        public Builder withAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
            return this;
        }

        public Builder withAcceptQueueSize(Integer acceptQueueSize) {
            this.acceptQueueSize = acceptQueueSize;
            return this;
        }

        public Builder withRequestHeaderSize(Integer requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        public JettySettings build() {
            return new JettySettings(Optional.fromNullable((Object)this.acceptors), Optional.fromNullable((Object)this.acceptQueueSize), Optional.fromNullable((Object)this.requestHeaderSize));
        }
    }
}

