/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolPB;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class QJournalProtocolTranslatorPB
implements ProtocolMetaInterface,
QJournalProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final QJournalProtocolPB rpcProxy;

    public QJournalProtocolTranslatorPB(QJournalProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public boolean isFormatted(String journalId) throws IOException {
        try {
            QJournalProtocolProtos.IsFormattedRequestProto req = QJournalProtocolProtos.IsFormattedRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).build();
            QJournalProtocolProtos.IsFormattedResponseProto resp = this.rpcProxy.isFormatted(NULL_CONTROLLER, req);
            return resp.getIsFormatted();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public QJournalProtocolProtos.GetJournalStateResponseProto getJournalState(String jid) throws IOException {
        try {
            QJournalProtocolProtos.GetJournalStateRequestProto req = QJournalProtocolProtos.GetJournalStateRequestProto.newBuilder().setJid(this.convertJournalId(jid)).build();
            return this.rpcProxy.getJournalState(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private QJournalProtocolProtos.JournalIdProto convertJournalId(String jid) {
        return QJournalProtocolProtos.JournalIdProto.newBuilder().setIdentifier(jid).build();
    }

    @Override
    public void format(String jid, NamespaceInfo nsInfo) throws IOException {
        try {
            QJournalProtocolProtos.FormatRequestProto req = QJournalProtocolProtos.FormatRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setNsInfo(PBHelper.convert(nsInfo)).build();
            this.rpcProxy.format(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public QJournalProtocolProtos.NewEpochResponseProto newEpoch(String jid, NamespaceInfo nsInfo, long epoch) throws IOException {
        try {
            QJournalProtocolProtos.NewEpochRequestProto req = QJournalProtocolProtos.NewEpochRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setNsInfo(PBHelper.convert(nsInfo)).setEpoch(epoch).build();
            return this.rpcProxy.newEpoch(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void journal(RequestInfo reqInfo, long segmentTxId, long firstTxnId, int numTxns, byte[] records) throws IOException {
        QJournalProtocolProtos.JournalRequestProto req = QJournalProtocolProtos.JournalRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setSegmentTxnId(segmentTxId).setFirstTxnId(firstTxnId).setNumTxns(numTxns).setRecords(PBHelper.getByteString(records)).build();
        try {
            this.rpcProxy.journal(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void heartbeat(RequestInfo reqInfo) throws IOException {
        try {
            this.rpcProxy.heartbeat(NULL_CONTROLLER, QJournalProtocolProtos.HeartbeatRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private QJournalProtocolProtos.RequestInfoProto convert(RequestInfo reqInfo) {
        QJournalProtocolProtos.RequestInfoProto.Builder builder = QJournalProtocolProtos.RequestInfoProto.newBuilder().setJournalId(this.convertJournalId(reqInfo.getJournalId())).setEpoch(reqInfo.getEpoch()).setIpcSerialNumber(reqInfo.getIpcSerialNumber());
        if (reqInfo.hasCommittedTxId()) {
            builder.setCommittedTxId(reqInfo.getCommittedTxId());
        }
        return builder.build();
    }

    @Override
    public void startLogSegment(RequestInfo reqInfo, long txid, int layoutVersion) throws IOException {
        QJournalProtocolProtos.StartLogSegmentRequestProto req = QJournalProtocolProtos.StartLogSegmentRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setTxid(txid).setLayoutVersion(layoutVersion).build();
        try {
            this.rpcProxy.startLogSegment(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void finalizeLogSegment(RequestInfo reqInfo, long startTxId, long endTxId) throws IOException {
        QJournalProtocolProtos.FinalizeLogSegmentRequestProto req = QJournalProtocolProtos.FinalizeLogSegmentRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setStartTxId(startTxId).setEndTxId(endTxId).build();
        try {
            this.rpcProxy.finalizeLogSegment(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void purgeLogsOlderThan(RequestInfo reqInfo, long minTxIdToKeep) throws IOException {
        QJournalProtocolProtos.PurgeLogsRequestProto req = QJournalProtocolProtos.PurgeLogsRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setMinTxIdToKeep(minTxIdToKeep).build();
        try {
            this.rpcProxy.purgeLogs(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public QJournalProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(String jid, long sinceTxId, boolean inProgressOk) throws IOException {
        try {
            return this.rpcProxy.getEditLogManifest(NULL_CONTROLLER, QJournalProtocolProtos.GetEditLogManifestRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setSinceTxId(sinceTxId).setInProgressOk(inProgressOk).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public QJournalProtocolProtos.PrepareRecoveryResponseProto prepareRecovery(RequestInfo reqInfo, long segmentTxId) throws IOException {
        try {
            return this.rpcProxy.prepareRecovery(NULL_CONTROLLER, QJournalProtocolProtos.PrepareRecoveryRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setSegmentTxId(segmentTxId).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void acceptRecovery(RequestInfo reqInfo, QJournalProtocolProtos.SegmentStateProto stateToAccept, URL fromUrl) throws IOException {
        try {
            this.rpcProxy.acceptRecovery(NULL_CONTROLLER, QJournalProtocolProtos.AcceptRecoveryRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setStateToAccept(stateToAccept).setFromURL(fromUrl.toExternalForm()).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, QJournalProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(QJournalProtocolPB.class), (String)methodName);
    }

    @Override
    public void doPreUpgrade(String jid) throws IOException {
        try {
            this.rpcProxy.doPreUpgrade(NULL_CONTROLLER, QJournalProtocolProtos.DoPreUpgradeRequestProto.newBuilder().setJid(this.convertJournalId(jid)).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void doUpgrade(String journalId, StorageInfo sInfo) throws IOException {
        try {
            this.rpcProxy.doUpgrade(NULL_CONTROLLER, QJournalProtocolProtos.DoUpgradeRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setSInfo(PBHelper.convert(sInfo)).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void doFinalize(String jid) throws IOException {
        try {
            this.rpcProxy.doFinalize(NULL_CONTROLLER, QJournalProtocolProtos.DoFinalizeRequestProto.newBuilder().setJid(this.convertJournalId(jid)).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public Boolean canRollBack(String journalId, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        try {
            QJournalProtocolProtos.CanRollBackResponseProto response = this.rpcProxy.canRollBack(NULL_CONTROLLER, QJournalProtocolProtos.CanRollBackRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setStorage(PBHelper.convert(storage)).setPrevStorage(PBHelper.convert(prevStorage)).setTargetLayoutVersion(targetLayoutVersion).build());
            return response.getCanRollBack();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void doRollback(String journalId) throws IOException {
        try {
            this.rpcProxy.doRollback(NULL_CONTROLLER, QJournalProtocolProtos.DoRollbackRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public Long getJournalCTime(String journalId) throws IOException {
        try {
            QJournalProtocolProtos.GetJournalCTimeResponseProto response = this.rpcProxy.getJournalCTime(NULL_CONTROLLER, QJournalProtocolProtos.GetJournalCTimeRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).build());
            return response.getResultCTime();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void discardSegments(String journalId, long startTxId) throws IOException {
        try {
            this.rpcProxy.discardSegments(NULL_CONTROLLER, QJournalProtocolProtos.DiscardSegmentsRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setStartTxId(startTxId).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }
}

