/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericListEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AnovaEvaluator
extends RecursiveNumericListEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public AnovaEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        List anovaInput = Arrays.stream(values).map(value -> ((List)value).stream().mapToDouble(Number::doubleValue).toArray()).collect(Collectors.toList());
        OneWayAnova anova = new OneWayAnova();
        double p = anova.anovaPValue(anovaInput);
        double f = anova.anovaFValue(anovaInput);
        HashMap<String, Double> m = new HashMap<String, Double>();
        m.put("p-value", p);
        m.put("f-ratio", f);
        return new Tuple(m);
    }
}

